/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.util.GriffonNameUtils;
import java.awt.Polygon;
import java.util.List;

public class PolygonPropertyEditor
extends AbstractPropertyEditor {
    public String getAsText() {
        if (null == this.getValue()) {
            return null;
        }
        Polygon polygon = (Polygon)this.getValue();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < polygon.npoints; ++i) {
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(polygon.xpoints[i]).append(", ").append(polygon.ypoints[i]);
        }
        return stringBuilder.toString();
    }

    protected void setValueInternal(Object object) {
        if (null == object) {
            super.setValueInternal(null);
        } else if (object instanceof CharSequence) {
            this.handleAsString(String.valueOf(object));
        } else if (object instanceof List) {
            this.handleAsList((List)object);
        } else if (object instanceof Polygon) {
            super.setValueInternal(object);
        } else {
            throw this.illegalValue(object, Polygon.class);
        }
    }

    protected void handleAsString(String string) {
        if (GriffonNameUtils.isBlank((String)string)) {
            super.setValueInternal(null);
            return;
        }
        String[] stringArray = string.split(",");
        if (stringArray.length % 2 == 1) {
            throw this.illegalValue(string, Polygon.class);
        }
        int n = stringArray.length / 2;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.parse(stringArray[2 * i]);
            nArray2[i] = this.parse(stringArray[2 * i + 1]);
        }
        super.setValueInternal((Object)new Polygon(nArray, nArray2, n));
    }

    protected void handleAsList(List<?> list) {
        if (list.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        if (list.size() % 2 == 1) {
            throw this.illegalValue(list, Polygon.class);
        }
        int n = list.size() / 2;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.parseValue(list.get(2 * i));
            nArray2[i] = this.parseValue(list.get(2 * i + 1));
        }
        super.setValueInternal((Object)new Polygon(nArray, nArray2, n));
    }

    protected int parseValue(Object object) {
        if (object instanceof CharSequence) {
            return this.parse(String.valueOf(object));
        }
        if (object instanceof Number) {
            return this.parse((Number)object);
        }
        throw this.illegalValue(object, Polygon.class);
    }

    protected int parse(String string) {
        try {
            return Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw this.illegalValue(string, Polygon.class, numberFormatException);
        }
    }

    protected int parse(Number number) {
        return number.intValue();
    }
}

