/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.util.GriffonNameUtils;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Map;

public class Rectangle2DPropertyEditor
extends AbstractPropertyEditor {
    public String getAsText() {
        if (null == this.getValue()) {
            return null;
        }
        Rectangle2D rectangle2D = (Rectangle2D)this.getValue();
        return rectangle2D.getX() + ", " + rectangle2D.getY() + ", " + rectangle2D.getWidth() + ", " + rectangle2D.getHeight();
    }

    protected void setValueInternal(Object object) {
        if (null == object) {
            super.setValueInternal(null);
        } else if (object instanceof CharSequence) {
            this.handleAsString(String.valueOf(object));
        } else if (object instanceof List) {
            this.handleAsList((List)object);
        } else if (object instanceof Map) {
            this.handleAsMap((Map)object);
        } else if (object instanceof Rectangle2D) {
            super.setValueInternal(object);
        } else {
            throw this.illegalValue(object, Rectangle2D.class);
        }
    }

    protected void handleAsString(String string) {
        if (GriffonNameUtils.isBlank((String)string)) {
            super.setValueInternal(null);
            return;
        }
        String[] stringArray = string.split(",");
        switch (stringArray.length) {
            case 4: {
                double d = this.parseValue(stringArray[0]);
                double d2 = this.parseValue(stringArray[1]);
                double d3 = this.parseValue(stringArray[2]);
                double d4 = this.parseValue(stringArray[3]);
                super.setValueInternal((Object)new Rectangle2D.Double(d, d2, d3, d4));
                break;
            }
            default: {
                throw this.illegalValue(string, Rectangle2D.class);
            }
        }
    }

    protected void handleAsList(List<?> list) {
        if (list.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        switch (list.size()) {
            case 4: {
                double d = this.parseValue(list.get(0));
                double d2 = this.parseValue(list.get(1));
                double d3 = this.parseValue(list.get(2));
                double d4 = this.parseValue(list.get(3));
                super.setValueInternal((Object)new Rectangle2D.Double(d, d2, d3, d4));
                break;
            }
            default: {
                throw this.illegalValue(list, Rectangle2D.class);
            }
        }
    }

    protected void handleAsMap(Map<?, ?> map) {
        if (map.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        double d = this.getMapValue(map, "x", 0.0);
        double d2 = this.getMapValue(map, "y", 0.0);
        double d3 = this.getMapValue(map, "width", 0.0);
        double d4 = this.getMapValue(map, "height", 0.0);
        super.setValueInternal((Object)new Rectangle2D.Double(d, d2, d3, d4));
    }

    protected double parseValue(Object object) {
        if (object instanceof CharSequence) {
            return this.parse(String.valueOf(object));
        }
        if (object instanceof Number) {
            return this.parse((Number)object);
        }
        throw this.illegalValue(object, Rectangle2D.class);
    }

    protected double parse(String string) {
        try {
            return Double.parseDouble(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw this.illegalValue(string, Rectangle2D.class, numberFormatException);
        }
    }

    protected double parse(Number number) {
        return number.doubleValue();
    }

    protected double getMapValue(Map<?, ?> map, String string, double d) {
        Object obj = map.get(string);
        if (null == obj) {
            obj = map.get(String.valueOf(string.charAt(0)));
        }
        if (null == obj) {
            return d;
        }
        if (obj instanceof CharSequence) {
            return this.parse(String.valueOf(obj));
        }
        if (obj instanceof Number) {
            return this.parse((Number)obj);
        }
        throw this.illegalValue(map, Rectangle2D.class);
    }
}

