/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.formatters;

import griffon.core.formatters.AbstractFormatter;
import griffon.core.formatters.ParseException;
import griffon.swing.support.Colors;
import griffon.util.GriffonNameUtils;
import java.awt.Color;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ColorFormatter
extends AbstractFormatter<Color> {
    public static final String PATTERN_SHORT = "#RGB";
    public static final String PATTERN_SHORT_WITH_ALPHA = "#RGBA";
    public static final String PATTERN_LONG = "#RRGGBB";
    public static final String PATTERN_LONG_WITH_ALPHA = "#RRGGBBAA";
    public static final String DEFAULT_PATTERN = "#RRGGBB";
    private static final String[] PATTERNS = new String[]{"#RRGGBB", "#RRGGBBAA", "#RGB", "#RGBA"};
    public static final ColorFormatter SHORT = new ColorFormatter("#RGB");
    public static final ColorFormatter SHORT_WITH_ALPHA = new ColorFormatter("#RGBA");
    public static final ColorFormatter LONG = new ColorFormatter("#RRGGBB");
    public static final ColorFormatter LONG_WITH_ALPHA = new ColorFormatter("#RRGGBBAA");
    private final ColorFormatterDelegate delegate;

    @Nonnull
    public static ColorFormatter getInstance(@Nullable String string) {
        return new ColorFormatter(string);
    }

    protected ColorFormatter(@Nullable String string) {
        if (PATTERN_SHORT.equals(string)) {
            this.delegate = new ShortColorFormatterDelegate();
        } else if (PATTERN_SHORT_WITH_ALPHA.equals(string)) {
            this.delegate = new ShortWithAlphaColorFormatterDelegate();
        } else if ("#RRGGBB".equals(string)) {
            this.delegate = new LongColorFormatterDelegate();
        } else if (PATTERN_LONG_WITH_ALPHA.equals(string)) {
            this.delegate = new LongWithAlphaColorFormatterDelegate();
        } else if (GriffonNameUtils.isBlank((String)string)) {
            this.delegate = new LongColorFormatterDelegate();
        } else {
            throw new IllegalArgumentException("Invalid pattern '" + string + "'. Valid patterns are " + Arrays.toString(PATTERNS));
        }
    }

    @Nullable
    public String format(@Nullable Color color) {
        return color == null ? null : this.delegate.format(color);
    }

    @Nullable
    public Color parse(@Nullable String string) throws ParseException {
        return GriffonNameUtils.isBlank((String)string) ? null : this.delegate.parse(string);
    }

    @Nonnull
    public String getPattern() {
        return this.delegate.getPattern();
    }

    @Nonnull
    public static Color parseColor(@Nonnull String string) throws ParseException {
        GriffonNameUtils.requireNonBlank((String)string, (String)"Argument must not be blank");
        if (string.startsWith("#")) {
            switch (string.length()) {
                case 4: {
                    return SHORT.parse(string);
                }
                case 5: {
                    return SHORT_WITH_ALPHA.parse(string);
                }
                case 7: {
                    return LONG.parse(string);
                }
                case 9: {
                    return LONG_WITH_ALPHA.parse(string);
                }
            }
            throw ColorFormatter.parseError((Object)string, Color.class);
        }
        try {
            return Colors.valueOf(string.toUpperCase()).getColor();
        }
        catch (Exception exception) {
            throw ColorFormatter.parseError((Object)string, Color.class, (Exception)exception);
        }
    }

    private static String padLeft(String string, String string2) {
        return 2 <= string.length() ? string : string2 + string;
    }

    private static class LongWithAlphaColorFormatterDelegate
    extends AbstractColorFormatterDelegate {
        private LongWithAlphaColorFormatterDelegate() {
            super(ColorFormatter.PATTERN_LONG_WITH_ALPHA);
        }

        @Override
        @Nonnull
        public String format(@Nonnull Color color) {
            Objects.requireNonNull(color, "Cannot format given Color because it's null");
            return "#" + ColorFormatter.padLeft(Integer.toHexString(color.getRed()), "0") + ColorFormatter.padLeft(Integer.toHexString(color.getGreen()), "0") + ColorFormatter.padLeft(Integer.toHexString(color.getBlue()), "0") + ColorFormatter.padLeft(Integer.toHexString(color.getAlpha()), "0");
        }

        @Override
        @Nonnull
        public Color parse(@Nonnull String string) throws ParseException {
            if (!string.startsWith("#") || string.length() != 9) {
                throw ColorFormatter.parseError((Object)string, (Class)Color.class);
            }
            int n = ColorFormatter.parseHexInt((String)("" + string.charAt(1) + string.charAt(2)).toUpperCase(), (Class)Color.class);
            int n2 = ColorFormatter.parseHexInt((String)("" + string.charAt(3) + string.charAt(4)).toUpperCase(), (Class)Color.class);
            int n3 = ColorFormatter.parseHexInt((String)("" + string.charAt(5) + string.charAt(6)).toUpperCase(), (Class)Color.class);
            int n4 = ColorFormatter.parseHexInt((String)("" + string.charAt(7) + string.charAt(8)).toUpperCase(), (Class)Color.class);
            return new Color(n, n2, n3, n4);
        }
    }

    private static class LongColorFormatterDelegate
    extends AbstractColorFormatterDelegate {
        private LongColorFormatterDelegate() {
            super("#RRGGBB");
        }

        @Override
        @Nonnull
        public String format(@Nonnull Color color) {
            Objects.requireNonNull(color, "Cannot format given Color because it's null");
            return "#" + ColorFormatter.padLeft(Integer.toHexString(color.getRed()), "0") + ColorFormatter.padLeft(Integer.toHexString(color.getGreen()), "0") + ColorFormatter.padLeft(Integer.toHexString(color.getBlue()), "0");
        }

        @Override
        @Nonnull
        public Color parse(@Nonnull String string) throws ParseException {
            if (!string.startsWith("#") || string.length() != 7) {
                throw ColorFormatter.parseError((Object)string, (Class)Color.class);
            }
            int n = ColorFormatter.parseHexInt((String)("" + string.charAt(1) + string.charAt(2)).toUpperCase(), (Class)Color.class);
            int n2 = ColorFormatter.parseHexInt((String)("" + string.charAt(3) + string.charAt(4)).toUpperCase(), (Class)Color.class);
            int n3 = ColorFormatter.parseHexInt((String)("" + string.charAt(5) + string.charAt(6)).toUpperCase(), (Class)Color.class);
            return new Color(n, n2, n3);
        }
    }

    private static class ShortWithAlphaColorFormatterDelegate
    extends AbstractColorFormatterDelegate {
        private ShortWithAlphaColorFormatterDelegate() {
            super(ColorFormatter.PATTERN_SHORT_WITH_ALPHA);
        }

        @Override
        @Nonnull
        public String format(@Nonnull Color color) {
            Objects.requireNonNull(color, "Cannot format given Color because it's null");
            return "#" + Integer.toHexString(color.getRed()).charAt(0) + Integer.toHexString(color.getGreen()).charAt(0) + Integer.toHexString(color.getBlue()).charAt(0) + Integer.toHexString(color.getAlpha()).charAt(0);
        }

        @Override
        @Nonnull
        public Color parse(@Nonnull String string) throws ParseException {
            if (!string.startsWith("#") || string.length() != 5) {
                throw ColorFormatter.parseError((Object)string, (Class)Color.class);
            }
            int n = ColorFormatter.parseHexInt((String)("" + string.charAt(1) + string.charAt(1)).toUpperCase(), (Class)Color.class);
            int n2 = ColorFormatter.parseHexInt((String)("" + string.charAt(2) + string.charAt(2)).toUpperCase(), (Class)Color.class);
            int n3 = ColorFormatter.parseHexInt((String)("" + string.charAt(3) + string.charAt(3)).toUpperCase(), (Class)Color.class);
            int n4 = ColorFormatter.parseHexInt((String)("" + string.charAt(4) + string.charAt(4)).toUpperCase(), (Class)Color.class);
            return new Color(n, n2, n3, n4);
        }
    }

    private static class ShortColorFormatterDelegate
    extends AbstractColorFormatterDelegate {
        private ShortColorFormatterDelegate() {
            super(ColorFormatter.PATTERN_SHORT);
        }

        @Override
        @Nonnull
        public String format(@Nonnull Color color) {
            Objects.requireNonNull(color, "Cannot format given Color because it's null");
            return "#" + Integer.toHexString(color.getRed()).charAt(0) + Integer.toHexString(color.getGreen()).charAt(0) + Integer.toHexString(color.getBlue()).charAt(0);
        }

        @Override
        @Nonnull
        public Color parse(@Nonnull String string) throws ParseException {
            if (!string.startsWith("#") || string.length() != 4) {
                throw ColorFormatter.parseError((Object)string, (Class)Color.class);
            }
            int n = ColorFormatter.parseHexInt((String)("" + string.charAt(1) + string.charAt(1)).toUpperCase(), (Class)Color.class);
            int n2 = ColorFormatter.parseHexInt((String)("" + string.charAt(2) + string.charAt(2)).toUpperCase(), (Class)Color.class);
            int n3 = ColorFormatter.parseHexInt((String)("" + string.charAt(3) + string.charAt(3)).toUpperCase(), (Class)Color.class);
            return new Color(n, n2, n3);
        }
    }

    private static abstract class AbstractColorFormatterDelegate
    implements ColorFormatterDelegate {
        private final String pattern;

        private AbstractColorFormatterDelegate(@Nonnull String string) {
            this.pattern = string;
        }

        @Override
        @Nonnull
        public String getPattern() {
            return this.pattern;
        }
    }

    private static interface ColorFormatterDelegate {
        @Nonnull
        public String getPattern();

        @Nonnull
        public String format(@Nonnull Color var1);

        @Nonnull
        public Color parse(@Nonnull String var1) throws ParseException;
    }
}

