/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.support;

import griffon.core.CallableWithArgs;
import griffon.core.RunnableWithArgs;
import griffon.util.GriffonNameUtils;
import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class SwingAction
extends AbstractAction {
    private static final long serialVersionUID = 4493562556110760713L;
    private static final String ERROR_CALLABLE_NULL = "Argument 'callable' must not be null";
    private static final String ERROR_RUNNABLE_NULL = "Argument 'runnable' must not be null";
    private RunnableWithArgs runnable;

    @Deprecated
    public SwingAction(final @Nonnull CallableWithArgs<?> callableWithArgs) {
        Objects.requireNonNull(callableWithArgs, ERROR_CALLABLE_NULL);
        this.runnable = new RunnableWithArgs(){

            public void run(Object ... objectArray) {
                callableWithArgs.call(objectArray);
            }
        };
    }

    public SwingAction(@Nonnull RunnableWithArgs runnableWithArgs) {
        this.runnable = Objects.requireNonNull(runnableWithArgs, ERROR_RUNNABLE_NULL);
    }

    @Nonnull
    public static ActionBuilder action() {
        return new ActionBuilder();
    }

    @Nonnull
    public static ActionBuilder action(@Nullable Action action) {
        return new ActionBuilder(action);
    }

    @Nonnull
    public static ActionBuilder action(@Nullable String string) {
        return new ActionBuilder().withName(string);
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        this.runnable.run(new Object[]{actionEvent});
    }

    public static class ActionBuilder {
        private String name;
        private int mnemonic;
        private KeyStroke accelerator;
        private String shortDescription;
        private String longDescription;
        private String command;
        private Icon smallIcon;
        private Icon largeIcon;
        private RunnableWithArgs runnable;
        private boolean enabled = true;
        private boolean selected = false;
        private Action action;
        private boolean mnemonicSet = false;
        private boolean enabledSet = false;
        private boolean selectedSet = false;

        public ActionBuilder() {
            this(null);
        }

        @Nonnull
        public ActionBuilder(@Nullable Action action) {
            this.action = action;
        }

        @Nonnull
        public ActionBuilder withName(@Nullable String string) {
            this.name = string;
            return this;
        }

        @Nonnull
        public ActionBuilder withShortDescription(@Nullable String string) {
            this.shortDescription = string;
            return this;
        }

        @Nonnull
        public ActionBuilder withLongDescription(@Nullable String string) {
            this.longDescription = string;
            return this;
        }

        @Nonnull
        public ActionBuilder withCommand(@Nullable String string) {
            this.command = string;
            return this;
        }

        @Nonnull
        public ActionBuilder withMnemonic(@Nullable String string) {
            if (!GriffonNameUtils.isBlank((String)string)) {
                this.mnemonic = KeyStroke.getKeyStroke(string).getKeyCode();
            }
            this.mnemonicSet = true;
            return this;
        }

        @Nonnull
        public ActionBuilder withMnemonic(int n) {
            this.mnemonic = n;
            this.mnemonicSet = true;
            return this;
        }

        @Nonnull
        public ActionBuilder withAccelerator(@Nullable String string) {
            if (!GriffonNameUtils.isBlank((String)string)) {
                this.accelerator = KeyStroke.getKeyStroke(string);
            }
            return this;
        }

        @Nonnull
        public ActionBuilder withAccelerator(@Nullable KeyStroke keyStroke) {
            this.accelerator = keyStroke;
            return this;
        }

        @Nonnull
        public ActionBuilder withSmallIcon(@Nullable Icon icon) {
            this.smallIcon = icon;
            return this;
        }

        @Nonnull
        public ActionBuilder withLargeIcon(@Nullable Icon icon) {
            this.largeIcon = icon;
            return this;
        }

        @Nonnull
        @Deprecated
        public ActionBuilder withRunnable(final @Nullable CallableWithArgs<?> callableWithArgs) {
            Objects.requireNonNull(callableWithArgs, SwingAction.ERROR_CALLABLE_NULL);
            this.runnable = new RunnableWithArgs(){

                public void run(Object ... objectArray) {
                    callableWithArgs.call(objectArray);
                }
            };
            return this;
        }

        @Nonnull
        public ActionBuilder withRunnable(@Nullable RunnableWithArgs runnableWithArgs) {
            this.runnable = runnableWithArgs;
            return this;
        }

        @Nonnull
        public ActionBuilder withEnabled(boolean bl) {
            this.enabled = bl;
            this.enabledSet = true;
            return this;
        }

        @Nonnull
        public ActionBuilder withSelected(boolean bl) {
            this.selected = bl;
            this.enabledSet = true;
            return this;
        }

        @Nonnull
        public Action build() {
            if (this.runnable == null && this.action == null) {
                throw new IllegalArgumentException("Either runnable, callable, or action must have a value.");
            }
            if (this.action == null) {
                this.action = new SwingAction(this.runnable);
            }
            if (!GriffonNameUtils.isBlank((String)this.command)) {
                this.action.putValue("ActionCommandKey", this.command);
            }
            if (!GriffonNameUtils.isBlank((String)this.name)) {
                this.action.putValue("Name", this.name);
            }
            if (this.mnemonicSet) {
                this.action.putValue("MnemonicKey", this.mnemonic);
            }
            if (this.accelerator != null) {
                this.action.putValue("AcceleratorKey", this.accelerator);
            }
            if (this.largeIcon != null) {
                this.action.putValue("SwingLargeIconKey", this.largeIcon);
            }
            if (this.smallIcon != null) {
                this.action.putValue("SmallIcon", this.smallIcon);
            }
            if (!GriffonNameUtils.isBlank((String)this.longDescription)) {
                this.action.putValue("LongDescription", this.longDescription);
            }
            if (!GriffonNameUtils.isBlank((String)this.shortDescription)) {
                this.action.putValue("ShortDescription", this.shortDescription);
            }
            if (this.enabledSet) {
                this.action.setEnabled(this.enabled);
            }
            if (this.selectedSet) {
                this.action.putValue("SwingSelectedKey", this.selected);
            }
            return this.action;
        }
    }
}

