/*
 * Decompiled with CFR 0.152.
 */
package griffon.swing.support;

import griffon.core.GriffonApplication;
import griffon.util.GriffonClassUtils;
import griffon.util.GriffonNameUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;

public class SwingUtils {
    private static final String ERROR_WINDOW_NULL = "Argument 'window' must not be null";

    public static void centerOnScreen(@Nonnull Window window) {
        Objects.requireNonNull(window, ERROR_WINDOW_NULL);
        Point point = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        double d = Math.min(window.getWidth(), dimension.width);
        double d2 = Math.min(window.getHeight(), dimension.height);
        int n = (int)((double)point.x - d / 2.0);
        int n2 = (int)((double)point.y - d2 / 2.0);
        Point point2 = new Point(n >= 0 ? n : 0, n2 >= 0 ? n2 : 0);
        window.setLocation(point2);
    }

    public static void centerOnScreen(@Nonnull JInternalFrame jInternalFrame) {
        Objects.requireNonNull(jInternalFrame, "Argument 'internalFrame' must not be null");
        JDesktopPane jDesktopPane = jInternalFrame.getDesktopPane();
        if (jDesktopPane == null) {
            return;
        }
        Dimension dimension = jDesktopPane.getSize();
        Point point = new Point(dimension.width / 2, dimension.height / 2);
        double d = Math.min(jInternalFrame.getWidth(), dimension.width);
        double d2 = Math.min(jInternalFrame.getHeight(), dimension.height);
        int n = (int)((double)point.x - d / 2.0);
        int n2 = (int)((double)point.y - d2 / 2.0);
        Point point2 = new Point(n >= 0 ? n : 0, n2 >= 0 ? n2 : 0);
        jInternalFrame.setLocation(point2);
    }

    public static float getWindowOpacity(@Nonnull Window window) {
        Objects.requireNonNull(window, ERROR_WINDOW_NULL);
        return window.getOpacity();
    }

    public static void setWindowOpacity(@Nonnull Window window, float f) {
        Objects.requireNonNull(window, ERROR_WINDOW_NULL);
        window.setOpacity(f);
    }

    @Nullable
    public static Component findComponentByName(@Nonnull String string, @Nonnull Container container) {
        Objects.requireNonNull(container, "Argument 'root' must not be null");
        GriffonNameUtils.requireNonBlank((String)string, (String)"Argument 'name' must not be blank");
        if (string.equals(container.getName())) {
            return container;
        }
        for (Component component : container.getComponents()) {
            Component component2;
            if (string.equals(component.getName())) {
                return component;
            }
            if (!(component instanceof Container) || (component2 = SwingUtils.findComponentByName(string, (Container)component)) == null) continue;
            return component2;
        }
        return null;
    }

    @Nonnull
    public static Image takeSnapshot(@Nonnull Component component) {
        return SwingUtils.takeSnapshot(component, false);
    }

    @Nonnull
    public static Image takeSnapshot(@Nonnull Component component, boolean bl) {
        Objects.requireNonNull(component, "Argument 'component' must not be null");
        BufferedImage bufferedImage = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        bufferedImage = graphicsConfiguration.getColorModel().hasAlpha() ? graphicsConfiguration.createCompatibleImage((int)component.getSize().getWidth(), (int)component.getSize().getHeight()) : new BufferedImage((int)component.getSize().getWidth(), (int)component.getSize().getHeight(), 2);
        Graphics graphics = bufferedImage.getGraphics();
        if (bl) {
            component.print(graphics);
        } else {
            component.paint(graphics);
        }
        graphics.dispose();
        return bufferedImage;
    }

    private static Class<?> loadClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException(classNotFoundException);
        }
    }

    @Nonnull
    public static Window createApplicationFrame(@Nonnull GriffonApplication griffonApplication, @Nonnull Map<String, Object> map) {
        ClassLoader classLoader;
        Objects.requireNonNull(griffonApplication, "Argument 'application' must not be null");
        JFrame jFrame = null;
        String string = griffonApplication.getConfiguration().getAsString("application.frameClass", JFrame.class.getName());
        if (!GriffonNameUtils.isBlank((String)string)) {
            try {
                classLoader = SwingUtils.class.getClassLoader();
                jFrame = classLoader != null ? (JFrame)classLoader.loadClass(string).newInstance() : (JFrame)Class.forName(string).newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (jFrame == null) {
            try {
                classLoader = SwingUtils.class.getClassLoader();
                jFrame = classLoader != null ? (JFrame)classLoader.loadClass("org.jdesktop.swingx.JXFrame").newInstance() : (JFrame)Class.forName("org.jdesktop.swingx.JXFrame").newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (jFrame == null) {
                jFrame = new JFrame();
            }
            jFrame.setDefaultCloseOperation(0);
        }
        GriffonClassUtils.setPropertiesNoException(jFrame, map);
        return jFrame;
    }
}

