/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.swing;

import griffon.core.CallableWithArgs;
import griffon.core.GriffonApplication;
import griffon.core.RunnableWithArgs;
import griffon.core.view.WindowDisplayHandler;
import griffon.exceptions.InstanceNotFoundException;
import griffon.swing.SwingWindowDisplayHandler;
import griffon.util.AnnotationUtils;
import griffon.util.GriffonNameUtils;
import java.awt.Window;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.swing.JInternalFrame;
import org.codehaus.griffon.runtime.core.view.ConfigurableWindowDisplayHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableSwingWindowDisplayHandler
extends ConfigurableWindowDisplayHandler<Window>
implements SwingWindowDisplayHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurableSwingWindowDisplayHandler.class);

    @Inject
    public ConfigurableSwingWindowDisplayHandler(@Nonnull GriffonApplication griffonApplication, @Nonnull @Named(value="defaultWindowDisplayHandler") SwingWindowDisplayHandler swingWindowDisplayHandler) {
        super(griffonApplication, (WindowDisplayHandler)swingWindowDisplayHandler);
    }

    @Override
    public void show(@Nonnull String string, @Nonnull JInternalFrame jInternalFrame) {
        Object v;
        Object object;
        GriffonNameUtils.requireNonBlank((String)string, (String)"Argument 'name' must not be blank");
        Objects.requireNonNull(jInternalFrame, "Argument 'window' must not be null");
        Map map = this.windowBlock(string);
        if (!map.isEmpty()) {
            object = map.get("show");
            if (this.canBeRun(object)) {
                LOG.trace("Showing {} with show: handler", (Object)string);
                this.run(object, string, jInternalFrame);
                return;
            }
            if (map.get("handler") instanceof SwingWindowDisplayHandler) {
                LOG.trace("Showing {} with handler: handler", (Object)string);
                ((SwingWindowDisplayHandler)map.get("handler")).show(string, jInternalFrame);
                return;
            }
        }
        if ((object = this.resolveSwingWindowDisplayHandler(string)) != null) {
            LOG.trace("Showing {} with injected handler", (Object)string);
            object.show(string, jInternalFrame);
            return;
        }
        map = this.windowManagerBlock();
        if (!map.isEmpty() && this.canBeRun(v = map.get("defaultShow"))) {
            LOG.trace("Showing {} with defaultShow: handler", (Object)string);
            this.run(v, string, jInternalFrame);
            return;
        }
        LOG.trace("Showing {} with default handler", (Object)string);
        this.fetchDefaultWindowDisplayHandler().show(string, jInternalFrame);
    }

    @Override
    public void hide(@Nonnull String string, @Nonnull JInternalFrame jInternalFrame) {
        Object v;
        Object object;
        GriffonNameUtils.requireNonBlank((String)string, (String)"Argument 'name' must not be blank");
        Objects.requireNonNull(jInternalFrame, "Argument 'window' must not be null");
        Map map = this.windowBlock(string);
        if (!map.isEmpty()) {
            object = map.get("hide");
            if (this.canBeRun(object)) {
                LOG.trace("Hiding {} with hide: handler", (Object)string);
                this.run(object, string, jInternalFrame);
                return;
            }
            if (map.get("handler") instanceof SwingWindowDisplayHandler) {
                LOG.trace("Hiding {} with handler: handler", (Object)string);
                ((SwingWindowDisplayHandler)map.get("handler")).hide(string, jInternalFrame);
                return;
            }
        }
        if ((object = this.resolveSwingWindowDisplayHandler(string)) != null) {
            LOG.trace("Hiding {} with injected handler", (Object)string);
            object.hide(string, jInternalFrame);
            return;
        }
        map = this.windowManagerBlock();
        if (!map.isEmpty() && this.canBeRun(v = map.get("defaultHide"))) {
            LOG.trace("Hiding {} with defaultHide: handler", (Object)string);
            this.run(v, string, jInternalFrame);
            return;
        }
        LOG.trace("Hiding {} with default handler", (Object)string);
        this.fetchDefaultWindowDisplayHandler().hide(string, jInternalFrame);
    }

    protected void run(@Nonnull Object object, @Nonnull String string, @Nonnull JInternalFrame jInternalFrame) {
        if (object instanceof RunnableWithArgs) {
            ((RunnableWithArgs)object).run(new Object[]{string, jInternalFrame});
        } else if (object instanceof CallableWithArgs) {
            ((CallableWithArgs)object).call(new Object[]{string, jInternalFrame});
        }
    }

    @Nonnull
    protected SwingWindowDisplayHandler fetchDefaultWindowDisplayHandler() {
        Object v = this.windowManagerBlock().get("defaultHandler");
        return (SwingWindowDisplayHandler)(v instanceof SwingWindowDisplayHandler ? v : this.getDelegateWindowsDisplayHandler());
    }

    protected boolean handleShowByInjectedHandler(@Nonnull String string, @Nonnull Window window) {
        try {
            SwingWindowDisplayHandler swingWindowDisplayHandler = (SwingWindowDisplayHandler)this.getApplication().getInjector().getInstance(SwingWindowDisplayHandler.class, (Annotation)AnnotationUtils.named((String)string));
            LOG.trace("Showing {} with injected handler", (Object)string);
            swingWindowDisplayHandler.show(string, window);
            return true;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            return super.handleShowByInjectedHandler(string, (Object)window);
        }
    }

    protected boolean handleHideByInjectedHandler(@Nonnull String string, @Nonnull Window window) {
        try {
            SwingWindowDisplayHandler swingWindowDisplayHandler = (SwingWindowDisplayHandler)this.getApplication().getInjector().getInstance(SwingWindowDisplayHandler.class, (Annotation)AnnotationUtils.named((String)string));
            LOG.trace("Hiding {} with injected handler", (Object)string);
            swingWindowDisplayHandler.hide(string, window);
            return true;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            return super.handleHideByInjectedHandler(string, (Object)window);
        }
    }

    protected SwingWindowDisplayHandler resolveSwingWindowDisplayHandler(@Nonnull String string) {
        try {
            return (SwingWindowDisplayHandler)this.getApplication().getInjector().getInstance(SwingWindowDisplayHandler.class, (Annotation)AnnotationUtils.named((String)string));
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            try {
                WindowDisplayHandler windowDisplayHandler = (WindowDisplayHandler)this.getApplication().getInjector().getInstance(WindowDisplayHandler.class, (Annotation)AnnotationUtils.named((String)string));
                if (windowDisplayHandler instanceof SwingWindowDisplayHandler) {
                    return (SwingWindowDisplayHandler)windowDisplayHandler;
                }
            }
            catch (InstanceNotFoundException instanceNotFoundException2) {
                // empty catch block
            }
            return null;
        }
    }
}

