/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.swing;

import griffon.core.ApplicationEvent;
import griffon.core.GriffonApplication;
import griffon.core.env.ApplicationPhase;
import griffon.core.view.WindowDisplayHandler;
import griffon.swing.SwingWindowDisplayHandler;
import griffon.swing.SwingWindowManager;
import griffon.util.GriffonNameUtils;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.codehaus.griffon.runtime.core.view.AbstractWindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSwingWindowManager
extends AbstractWindowManager<Window>
implements SwingWindowManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSwingWindowManager.class);
    private final WindowHelper windowHelper = new WindowHelper();
    private final ComponentHelper componentHelper = new ComponentHelper();
    private final InternalFrameHelper internalFrameHelper = new InternalFrameHelper();
    private final Map<String, JInternalFrame> internalFrames = Collections.synchronizedMap(new LinkedHashMap());
    private boolean hideBeforeHandler = false;

    @Inject
    @Nonnull
    public DefaultSwingWindowManager(@Nonnull GriffonApplication griffonApplication, @Nonnull @Named(value="windowDisplayHandler") SwingWindowDisplayHandler swingWindowDisplayHandler) {
        super(griffonApplication, (WindowDisplayHandler)swingWindowDisplayHandler);
        Objects.requireNonNull(griffonApplication.getEventRouter(), "Argument 'application.eventRouter' must not be null");
    }

    public JInternalFrame findInternalFrame(String string) {
        if (!GriffonNameUtils.isBlank((String)string)) {
            for (JInternalFrame jInternalFrame : this.internalFrames.values()) {
                if (!string.equals(jInternalFrame.getName())) continue;
                return jInternalFrame;
            }
        }
        return null;
    }

    @Override
    @Nonnull
    public Set<String> getInternalWindowNames() {
        return Collections.unmodifiableSet(this.internalFrames.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String findInternalWindowName(@Nonnull JInternalFrame jInternalFrame) {
        Objects.requireNonNull(jInternalFrame, "Argument 'window' must not be null");
        Map<String, JInternalFrame> map = this.internalFrames;
        synchronized (map) {
            for (Map.Entry<String, JInternalFrame> entry : this.internalFrames.entrySet()) {
                if (!entry.getValue().equals(jInternalFrame)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOfInternal(@Nonnull JInternalFrame jInternalFrame) {
        Objects.requireNonNull(jInternalFrame, "Argument 'window' must not be null");
        Map<String, JInternalFrame> map = this.internalFrames;
        synchronized (map) {
            int n = 0;
            for (JInternalFrame jInternalFrame2 : this.internalFrames.values()) {
                if (jInternalFrame.equals(jInternalFrame2)) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public Collection<JInternalFrame> getInternalFrames() {
        return Collections.unmodifiableCollection(this.internalFrames.values());
    }

    public void attach(@Nonnull String string, @Nonnull JInternalFrame jInternalFrame) {
        JInternalFrame jInternalFrame2;
        GriffonNameUtils.requireNonBlank((String)string, (String)"Argument 'name' must not be blank");
        Objects.requireNonNull(jInternalFrame, "Argument 'window' must not be null");
        if (this.internalFrames.containsKey(string) && (jInternalFrame2 = this.internalFrames.get(string)) != jInternalFrame) {
            this.detach(string);
        }
        this.doAttach(jInternalFrame);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attaching internal frame with name: '" + string + "' at index " + this.internalFrames.size() + " " + jInternalFrame);
        }
        this.internalFrames.put(string, jInternalFrame);
        this.event(ApplicationEvent.WINDOW_ATTACHED, Arrays.asList(string, jInternalFrame));
    }

    protected void doAttach(@Nonnull JInternalFrame jInternalFrame) {
        jInternalFrame.addInternalFrameListener(this.internalFrameHelper);
        jInternalFrame.setDefaultCloseOperation(0);
    }

    public void detach(@Nonnull String string) {
        GriffonNameUtils.requireNonBlank((String)string, (String)"Argument 'name' must not be blank");
        if (this.internalFrames.containsKey(string)) {
            JInternalFrame jInternalFrame = this.internalFrames.get(string);
            this.doDetach(jInternalFrame);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Detaching internalFrame with name: '" + string + "' " + jInternalFrame);
            }
            this.internalFrames.remove(string);
            this.event(ApplicationEvent.WINDOW_DETACHED, Arrays.asList(string, jInternalFrame));
        }
    }

    protected void doDetach(@Nonnull JInternalFrame jInternalFrame) {
        jInternalFrame.removeInternalFrameListener(this.internalFrameHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show(@Nonnull JInternalFrame jInternalFrame) {
        int n;
        Objects.requireNonNull(jInternalFrame, "Argument 'window' must not be null");
        if (!this.internalFrames.containsValue(jInternalFrame)) {
            return;
        }
        String string = null;
        int n2 = -1;
        Map<String, JInternalFrame> map = this.internalFrames;
        synchronized (map) {
            n = 0;
            for (Map.Entry<String, JInternalFrame> entry : this.internalFrames.entrySet()) {
                if (entry.getValue() == jInternalFrame) {
                    string = entry.getKey();
                    n2 = n;
                    break;
                }
                ++n;
            }
        }
        map = string;
        n = n2;
        this.getApplication().getUIThreadManager().runInsideUIAsync(new Runnable((String)((Object)map), n, jInternalFrame){
            final /* synthetic */ String val$name;
            final /* synthetic */ int val$index;
            final /* synthetic */ JInternalFrame val$internalFrame;
            {
                this.val$name = string;
                this.val$index = n;
                this.val$internalFrame = jInternalFrame;
            }

            @Override
            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Showing window with name: '" + this.val$name + "' at index " + this.val$index + " " + this.val$internalFrame);
                }
                DefaultSwingWindowManager.this.resolveSwingWindowDisplayHandler().show(this.val$name, this.val$internalFrame);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hide(@Nonnull JInternalFrame jInternalFrame) {
        int n;
        Objects.requireNonNull(jInternalFrame, "Argument 'window' must not be null");
        if (!this.internalFrames.containsValue(jInternalFrame)) {
            return;
        }
        String string = null;
        int n2 = -1;
        Map<String, JInternalFrame> map = this.internalFrames;
        synchronized (map) {
            n = 0;
            for (Map.Entry<String, JInternalFrame> entry : this.internalFrames.entrySet()) {
                if (entry.getValue() == jInternalFrame) {
                    string = entry.getKey();
                    n2 = n;
                    break;
                }
                ++n;
            }
        }
        map = string;
        n = n2;
        this.getApplication().getUIThreadManager().runInsideUIAsync(new Runnable((String)((Object)map), n, jInternalFrame){
            final /* synthetic */ String val$name;
            final /* synthetic */ int val$index;
            final /* synthetic */ JInternalFrame val$internalFrame;
            {
                this.val$name = string;
                this.val$index = n;
                this.val$internalFrame = jInternalFrame;
            }

            @Override
            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Hiding window with name: '" + this.val$name + "' at index " + this.val$index + " " + this.val$internalFrame);
                }
                DefaultSwingWindowManager.this.resolveSwingWindowDisplayHandler().hide(this.val$name, this.val$internalFrame);
            }
        });
    }

    public boolean isHideBeforeHandler() {
        return this.hideBeforeHandler;
    }

    public void setHideBeforeHandler(boolean bl) {
        this.hideBeforeHandler = bl;
    }

    @Nonnull
    protected SwingWindowDisplayHandler resolveSwingWindowDisplayHandler() {
        return (SwingWindowDisplayHandler)this.resolveWindowDisplayHandler();
    }

    protected void doAttach(@Nonnull Window window) {
        Objects.requireNonNull(window, "Argument 'window' must not be null");
        window.addWindowListener(this.windowHelper);
        window.addComponentListener(this.componentHelper);
    }

    protected void doDetach(@Nonnull Window window) {
        Objects.requireNonNull(window, "Argument 'window' must not be null");
        window.removeWindowListener(this.windowHelper);
        window.removeComponentListener(this.componentHelper);
    }

    protected boolean isWindowVisible(@Nonnull Window window) {
        Objects.requireNonNull(window, "Argument 'window' must not be null");
        return window.isVisible();
    }

    private class InternalFrameHelper
    extends InternalFrameAdapter {
        private InternalFrameHelper() {
        }

        @Override
        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
            DefaultSwingWindowManager.this.hide(internalFrameEvent.getInternalFrame());
        }

        @Override
        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
            JInternalFrame jInternalFrame = (JInternalFrame)internalFrameEvent.getSource();
            DefaultSwingWindowManager.this.event(ApplicationEvent.WINDOW_SHOWN, Arrays.asList(DefaultSwingWindowManager.this.findInternalWindowName(jInternalFrame), jInternalFrame));
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            JInternalFrame jInternalFrame = (JInternalFrame)internalFrameEvent.getSource();
            DefaultSwingWindowManager.this.event(ApplicationEvent.WINDOW_HIDDEN, Arrays.asList(DefaultSwingWindowManager.this.findInternalWindowName(jInternalFrame), jInternalFrame));
        }
    }

    private class ComponentHelper
    extends ComponentAdapter {
        private ComponentHelper() {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            Window window = (Window)componentEvent.getSource();
            DefaultSwingWindowManager.this.event(ApplicationEvent.WINDOW_SHOWN, Arrays.asList(DefaultSwingWindowManager.this.findWindowName(window), window));
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            Window window = (Window)componentEvent.getSource();
            DefaultSwingWindowManager.this.event(ApplicationEvent.WINDOW_HIDDEN, Arrays.asList(DefaultSwingWindowManager.this.findWindowName(window), window));
        }
    }

    private class WindowHelper
    extends WindowAdapter {
        private WindowHelper() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (DefaultSwingWindowManager.this.getApplication().getPhase() == ApplicationPhase.SHUTDOWN) {
                return;
            }
            int n = DefaultSwingWindowManager.this.countVisibleWindows();
            if (DefaultSwingWindowManager.this.isHideBeforeHandler() || n > 0) {
                DefaultSwingWindowManager.this.hide(windowEvent.getWindow());
            }
            if (n <= 1 && DefaultSwingWindowManager.this.isAutoShutdown()) {
                LOG.debug("Attempting to shutdown application");
                if (!DefaultSwingWindowManager.this.getApplication().shutdown()) {
                    DefaultSwingWindowManager.this.show(windowEvent.getWindow());
                }
            }
        }
    }
}

