/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.swing;

import griffon.core.CallableWithArgs;
import griffon.core.GriffonApplication;
import griffon.core.GriffonExceptionHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.swing.RepaintManager;
import org.codehaus.griffon.runtime.core.addon.AbstractGriffonAddon;
import org.jdesktop.swinghelper.debug.CheckThreadViolationRepaintManager;
import org.jdesktop.swinghelper.debug.EventDispatchThreadHangMonitor;
import sun.awt.AppContext;

@Named(value="swing")
public class SwingAddon
extends AbstractGriffonAddon {
    private static final String SWING_EDT_VIOLATIONS_KEY = "griffon.swing.edt.violations.check";
    private static final String SWING_EDT_HANG_MONITOR_KEY = "griffon.swing.edt.hang.monitor";
    private static final String SWING_EDT_HANG_MONITOR_TIMEOUT_KEY = "griffon.swing.edt.hang.monitor.timeout";
    private static final String[] EXCLUDED_PACKAGES = System.getProperty("groovy.sanitized.stacktraces", "groovy.,org.codehaus.groovy.,java.,javax.,sun.,gjdk.groovy.," + CheckThreadViolationRepaintManager.class.getPackage().getName()).split("(\\s|,)+");

    public void init(@Nonnull GriffonApplication griffonApplication) {
        String string = System.getProperty(SWING_EDT_VIOLATIONS_KEY);
        if (string != null && Boolean.parseBoolean(string)) {
            RepaintManager repaintManager;
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info("EDT violations check enabled.");
            }
            if (null == (repaintManager = this.getCurrentRepaintManager())) {
                repaintManager = new RepaintManager();
            }
            if (repaintManager instanceof CheckThreadViolationRepaintManager) {
                return;
            }
            RepaintManager.setCurrentManager(new CheckThreadViolationRepaintManager(repaintManager));
            GriffonExceptionHandler.addClassTest((CallableWithArgs)new CallableWithArgs<Boolean>(){

                @Nullable
                public Boolean call(Object ... objectArray) {
                    String string = (String)objectArray[0];
                    for (String string2 : EXCLUDED_PACKAGES) {
                        if (!string.startsWith(string2)) continue;
                        return false;
                    }
                    return true;
                }
            });
        }
        if ((string = System.getProperty(SWING_EDT_HANG_MONITOR_KEY)) != null && Boolean.parseBoolean(string)) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info("EDT hang monitor enabled.");
            }
            EventDispatchThreadHangMonitor.initMonitoring();
            string = System.getProperty(SWING_EDT_HANG_MONITOR_TIMEOUT_KEY);
            if (string != null) {
                try {
                    EventDispatchThreadHangMonitor.getInstance().setTimeout(Long.parseLong(string));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private RepaintManager getCurrentRepaintManager() {
        return (RepaintManager)AppContext.getAppContext().get(RepaintManager.class);
    }
}

