/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.swing;

import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.swing.SwingUtilities;
import org.codehaus.griffon.runtime.core.threading.AbstractUIThreadManager;

public class SwingUIThreadManager
extends AbstractUIThreadManager {
    public boolean isUIThread() {
        return SwingUtilities.isEventDispatchThread();
    }

    public void runInsideUIAsync(@Nonnull Runnable runnable) {
        Objects.requireNonNull(runnable, "Argument 'runnable' must not be null");
        SwingUtilities.invokeLater(runnable);
    }

    public void runInsideUISync(@Nonnull Runnable runnable) {
        Objects.requireNonNull(runnable, "Argument 'runnable' must not be null");
        if (this.isUIThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new RuntimeException(throwable);
            }
        }
    }
}

