/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.swing.controller;

import griffon.core.RunnableWithArgs;
import griffon.core.artifact.GriffonController;
import griffon.core.controller.ActionManager;
import griffon.core.editors.PropertyEditorResolver;
import griffon.core.threading.UIThreadManager;
import griffon.swing.support.SwingAction;
import griffon.util.GriffonNameUtils;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.codehaus.griffon.runtime.core.controller.AbstractAction;

public class SwingGriffonControllerAction
extends AbstractAction {
    public static final String KEY_SHORT_DESCRIPTION = "shortDescription";
    public static final String KEY_LONG_DESCRIPTION = "longDescription";
    public static final String KEY_SMALL_ICON = "smallIcon";
    public static final String KEY_LARGE_ICON = "largeIcon";
    public static final String KEY_SELECTED = "selected";
    public static final String KEY_ACCELERATOR = "accelerator";
    public static final String KEY_MNEMONIC = "mnemonic";
    public static final String KEY_COMMAND = "command";
    private final SwingAction toolkitAction;
    private String shortDescription;
    private String longDescription;
    private String smallIcon;
    private String largeIcon;
    private String accelerator;
    private String mnemonic;
    private String command;
    private boolean selected;

    public SwingGriffonControllerAction(final @Nonnull UIThreadManager uIThreadManager, @Nonnull ActionManager actionManager, @Nonnull GriffonController griffonController, @Nonnull String string) {
        super(actionManager, griffonController, string);
        Objects.requireNonNull(uIThreadManager, "Argument 'uiThreadManager' must not be null");
        this.toolkitAction = this.createAction(actionManager, griffonController, string);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
                uIThreadManager.runInsideUIAsync(new Runnable(){

                    @Override
                    public void run() {
                        SwingGriffonControllerAction.this.handlePropertyChange(propertyChangeEvent);
                    }
                });
            }
        });
    }

    @Nonnull
    protected SwingAction createAction(final @Nonnull ActionManager actionManager, final @Nonnull GriffonController griffonController, final @Nonnull String string) {
        return new SwingAction(new RunnableWithArgs(){

            public void run(Object ... objectArray) {
                actionManager.invokeAction(griffonController, string, objectArray);
            }
        });
    }

    protected void handlePropertyChange(@Nonnull PropertyChangeEvent propertyChangeEvent) {
        if ("name".equals(propertyChangeEvent.getPropertyName())) {
            this.toolkitAction.putValue("Name", propertyChangeEvent.getNewValue());
        } else if (KEY_COMMAND.equals(propertyChangeEvent.getPropertyName())) {
            this.toolkitAction.putValue("ActionCommandKey", propertyChangeEvent.getNewValue());
        } else if (KEY_SHORT_DESCRIPTION.equals(propertyChangeEvent.getPropertyName())) {
            this.toolkitAction.putValue("ShortDescription", propertyChangeEvent.getNewValue());
        } else if (KEY_LONG_DESCRIPTION.equals(propertyChangeEvent.getPropertyName())) {
            this.toolkitAction.putValue("LongDescription", propertyChangeEvent.getNewValue());
        } else if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
            this.toolkitAction.setEnabled((Boolean)propertyChangeEvent.getNewValue());
        } else if (KEY_SELECTED.equals(propertyChangeEvent.getPropertyName())) {
            this.toolkitAction.putValue("SwingSelectedKey", propertyChangeEvent.getNewValue());
        } else if (KEY_MNEMONIC.equals(propertyChangeEvent.getPropertyName())) {
            String string = (String)propertyChangeEvent.getNewValue();
            if (!GriffonNameUtils.isBlank((String)string)) {
                this.toolkitAction.putValue("MnemonicKey", KeyStroke.getKeyStroke(string).getKeyCode());
            }
        } else if (KEY_ACCELERATOR.equals(propertyChangeEvent.getPropertyName())) {
            String string = (String)propertyChangeEvent.getNewValue();
            if (!GriffonNameUtils.isBlank((String)string)) {
                this.toolkitAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(string));
            }
        } else if (KEY_SMALL_ICON.equals(propertyChangeEvent.getPropertyName())) {
            this.handleIcon(propertyChangeEvent.getNewValue(), "SmallIcon");
        } else if (KEY_LARGE_ICON.equals(propertyChangeEvent.getPropertyName())) {
            this.handleIcon(propertyChangeEvent.getNewValue(), "SwingLargeIconKey");
        }
    }

    protected void handleIcon(@Nullable Object object, @Nonnull String string) {
        if (object != null) {
            PropertyEditor propertyEditor = PropertyEditorResolver.findEditor(Icon.class);
            propertyEditor.setValue(object);
            this.toolkitAction.putValue(string, propertyEditor.getValue());
        }
    }

    protected void doInitialize() {
        String string;
        this.toolkitAction.putValue("Name", this.getName());
        this.toolkitAction.putValue("ActionCommandKey", this.getCommand());
        this.toolkitAction.putValue("ShortDescription", this.getShortDescription());
        this.toolkitAction.putValue("LongDescription", this.getLongDescription());
        this.toolkitAction.setEnabled(this.isEnabled());
        this.toolkitAction.putValue("SwingSelectedKey", this.isSelected());
        String string2 = this.getMnemonic();
        if (!GriffonNameUtils.isBlank((String)string2)) {
            this.toolkitAction.putValue("MnemonicKey", KeyStroke.getKeyStroke(string2).getKeyCode());
        }
        if (!GriffonNameUtils.isBlank((String)(string = this.getAccelerator()))) {
            this.toolkitAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(string));
        }
        this.handleIcon(this.getSmallIcon(), "SmallIcon");
        this.handleIcon(this.getLargeIcon(), "SwingLargeIconKey");
    }

    @Nullable
    public String getAccelerator() {
        return this.accelerator;
    }

    public void setAccelerator(@Nullable String string) {
        this.accelerator = string;
        this.firePropertyChange(KEY_ACCELERATOR, this.accelerator, this.accelerator);
    }

    @Nullable
    public String getLargeIcon() {
        return this.largeIcon;
    }

    public void setLargeIcon(@Nullable String string) {
        this.largeIcon = string;
        this.firePropertyChange(KEY_LARGE_ICON, this.largeIcon, this.largeIcon);
    }

    @Nullable
    public String getLongDescription() {
        return this.longDescription;
    }

    public void setLongDescription(@Nullable String string) {
        this.longDescription = string;
        this.firePropertyChange(KEY_LONG_DESCRIPTION, this.longDescription, this.longDescription);
    }

    @Nullable
    public String getMnemonic() {
        return this.mnemonic;
    }

    public void setMnemonic(@Nullable String string) {
        this.mnemonic = string;
        this.firePropertyChange(KEY_MNEMONIC, this.mnemonic, this.mnemonic);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        this.firePropertyChange(KEY_SELECTED, this.selected, this.selected);
    }

    @Nullable
    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(@Nullable String string) {
        this.shortDescription = string;
        this.firePropertyChange(KEY_SHORT_DESCRIPTION, this.shortDescription, this.shortDescription);
    }

    @Nullable
    public String getSmallIcon() {
        return this.smallIcon;
    }

    public void setSmallIcon(@Nullable String string) {
        this.smallIcon = string;
        this.firePropertyChange(KEY_SMALL_ICON, this.smallIcon, this.smallIcon);
    }

    @Nullable
    public String getCommand() {
        return this.command;
    }

    public void setCommand(@Nullable String string) {
        this.command = string;
        this.firePropertyChange(KEY_SMALL_ICON, this.command, this.command);
    }

    @Nonnull
    public Object getToolkitAction() {
        return this.toolkitAction;
    }

    protected void doExecute(Object ... objectArray) {
        ActionEvent actionEvent = null;
        if (objectArray != null && objectArray.length == 1 && objectArray[0] instanceof ActionEvent) {
            actionEvent = (ActionEvent)objectArray[0];
        }
        this.toolkitAction.actionPerformed(actionEvent);
    }
}

