/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swinghelper.debug;

import griffon.core.GriffonExceptionHandler;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckThreadViolationRepaintManager
extends RepaintManager {
    private static final Logger LOG = LoggerFactory.getLogger(CheckThreadViolationRepaintManager.class);
    private boolean completeCheck = true;
    private WeakReference<JComponent> lastComponent;
    private final RepaintManager delegate;

    public CheckThreadViolationRepaintManager() {
        this(new RepaintManager());
    }

    public CheckThreadViolationRepaintManager(RepaintManager repaintManager) {
        if (repaintManager == null || repaintManager instanceof CheckThreadViolationRepaintManager) {
            throw new IllegalArgumentException();
        }
        this.delegate = repaintManager;
    }

    public boolean isCompleteCheck() {
        return this.completeCheck;
    }

    public void setCompleteCheck(boolean bl) {
        this.completeCheck = bl;
    }

    @Override
    public synchronized void addInvalidComponent(JComponent jComponent) {
        this.checkThreadViolations(jComponent);
        this.delegate.addInvalidComponent(jComponent);
    }

    @Override
    public void addDirtyRegion(JComponent jComponent, int n, int n2, int n3, int n4) {
        this.checkThreadViolations(jComponent);
        this.delegate.addDirtyRegion(jComponent, n, n2, n3, n4);
    }

    private void checkThreadViolations(JComponent jComponent) {
        if (!SwingUtilities.isEventDispatchThread() && (this.completeCheck || jComponent.isShowing())) {
            StackTraceElement[] stackTraceElementArray;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (StackTraceElement stackTraceElement : stackTraceElementArray = Thread.currentThread().getStackTrace()) {
                if (bl && stackTraceElement.getClassName().startsWith("javax.swing.") && !stackTraceElement.getClassName().startsWith("javax.swing.SwingWorker")) {
                    bl2 = true;
                }
                if (bl && "imageUpdate".equals(stackTraceElement.getMethodName())) {
                    bl3 = true;
                }
                if (!"repaint".equals(stackTraceElement.getMethodName())) continue;
                bl = true;
                bl2 = false;
            }
            if (bl3) {
                return;
            }
            if (bl && !bl2) {
                return;
            }
            if (this.lastComponent != null && jComponent == this.lastComponent.get()) {
                return;
            }
            this.lastComponent = new WeakReference<JComponent>(jComponent);
            this.violationFound(jComponent, stackTraceElementArray);
        }
    }

    protected void violationFound(JComponent jComponent, StackTraceElement[] stackTraceElementArray) {
        stackTraceElementArray = GriffonExceptionHandler.sanitize((StackTraceElement[])stackTraceElementArray);
        StringBuilder stringBuilder = new StringBuilder("EDT violation detected").append('\n');
        stringBuilder.append(jComponent).append('\n');
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            stringBuilder.append("\tat ").append(stackTraceElement).append('\n');
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn(stringBuilder.toString());
        }
    }

    public static RepaintManager currentManager(Component component) {
        return RepaintManager.currentManager(component);
    }

    public static RepaintManager currentManager(JComponent jComponent) {
        return RepaintManager.currentManager(jComponent);
    }

    @Override
    public Rectangle getDirtyRegion(JComponent jComponent) {
        return this.delegate.getDirtyRegion(jComponent);
    }

    @Override
    public Dimension getDoubleBufferMaximumSize() {
        return this.delegate.getDoubleBufferMaximumSize();
    }

    @Override
    public Image getOffscreenBuffer(Component component, int n, int n2) {
        return this.delegate.getOffscreenBuffer(component, n, n2);
    }

    @Override
    public Image getVolatileOffscreenBuffer(Component component, int n, int n2) {
        return this.delegate.getVolatileOffscreenBuffer(component, n, n2);
    }

    @Override
    public boolean isCompletelyDirty(JComponent jComponent) {
        return this.delegate.isCompletelyDirty(jComponent);
    }

    @Override
    public boolean isDoubleBufferingEnabled() {
        return this.delegate.isDoubleBufferingEnabled();
    }

    @Override
    public void markCompletelyClean(JComponent jComponent) {
        this.delegate.markCompletelyClean(jComponent);
    }

    @Override
    public void markCompletelyDirty(JComponent jComponent) {
        this.delegate.markCompletelyDirty(jComponent);
    }

    @Override
    public void paintDirtyRegions() {
        this.delegate.paintDirtyRegions();
    }

    @Override
    public void removeInvalidComponent(JComponent jComponent) {
        this.delegate.removeInvalidComponent(jComponent);
    }

    public static void setCurrentManager(RepaintManager repaintManager) {
        RepaintManager.setCurrentManager(repaintManager);
    }

    @Override
    public void setDoubleBufferingEnabled(boolean bl) {
        this.delegate.setDoubleBufferingEnabled(bl);
    }

    @Override
    public void setDoubleBufferMaximumSize(Dimension dimension) {
        this.delegate.setDoubleBufferMaximumSize(dimension);
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public void validateInvalidComponents() {
        this.delegate.validateInvalidComponents();
    }

    @Override
    public void addDirtyRegion(Window window, int n, int n2, int n3, int n4) {
        this.delegate.addDirtyRegion(window, n, n2, n3, n4);
    }

    @Override
    public void addDirtyRegion(Applet applet, int n, int n2, int n3, int n4) {
        this.delegate.addDirtyRegion(applet, n, n2, n3, n4);
    }
}

