/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swinghelper.debug;

import griffon.core.GriffonExceptionHandler;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventDispatchThreadHangMonitor
extends EventQueue {
    private static final Logger LOG = LoggerFactory.getLogger(EventDispatchThreadHangMonitor.class);
    private static final EventDispatchThreadHangMonitor INSTANCE = new EventDispatchThreadHangMonitor();
    private static final long CHECK_INTERVAL_MS = 100L;
    private static final long UNREASONABLE_DISPATCH_DURATION_MS = 1000L;
    private static int hangCount = 0;
    private boolean haveShownSomeComponent = false;
    private final LinkedList<DispatchInfo> dispatches = new LinkedList();
    private long timeout = 1000L;

    private EventDispatchThreadHangMonitor() {
        this.initTimer();
    }

    private void initTimer() {
        Timer timer = new Timer("EventDispatchThreadHangMonitor", true);
        timer.schedule((TimerTask)new HangChecker(), 0L, 100L);
    }

    public static void initMonitoring() {
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(INSTANCE);
    }

    public static EventDispatchThreadHangMonitor getInstance() {
        return INSTANCE;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long l) {
        this.timeout = l > 1000L ? l : 1000L;
    }

    @Override
    protected void dispatchEvent(AWTEvent aWTEvent) {
        try {
            this.preDispatchEvent();
            super.dispatchEvent(aWTEvent);
        }
        finally {
            this.postDispatchEvent();
            if (!this.haveShownSomeComponent && aWTEvent instanceof WindowEvent && aWTEvent.getID() == 200) {
                this.haveShownSomeComponent = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void preDispatchEvent() {
        LinkedList<DispatchInfo> linkedList = this.dispatches;
        synchronized (linkedList) {
            this.dispatches.addLast(new DispatchInfo(this.timeout));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void postDispatchEvent() {
        LinkedList<DispatchInfo> linkedList = this.dispatches;
        synchronized (linkedList) {
            DispatchInfo dispatchInfo = this.dispatches.removeLast();
            dispatchInfo.dispose();
            Thread thread = Thread.currentThread();
            for (DispatchInfo dispatchInfo2 : this.dispatches) {
                if (dispatchInfo2.eventDispatchThread != thread) continue;
                dispatchInfo2.lastDispatchTimeMillis = System.currentTimeMillis();
            }
        }
    }

    private static void checkForDeadlock() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        long[] lArray = threadMXBean.findMonitorDeadlockedThreads();
        if (lArray == null) {
            return;
        }
        if (LOG.isWarnEnabled()) {
            ThreadInfo[] threadInfoArray;
            StringBuilder stringBuilder = new StringBuilder("Deadlock detected involving the following threads:");
            for (ThreadInfo threadInfo : threadInfoArray = threadMXBean.getThreadInfo(lArray, Integer.MAX_VALUE)) {
                stringBuilder.append("Thread #").append(threadInfo.getThreadId()).append(" ").append(threadInfo.getThreadName()).append(" (").append((Object)threadInfo.getThreadState()).append(") waiting on ").append(threadInfo.getLockName()).append(" held by ").append(threadInfo.getLockOwnerName()).append(EventDispatchThreadHangMonitor.stackTraceToString(GriffonExceptionHandler.sanitize((StackTraceElement[])threadInfo.getStackTrace())));
            }
            LOG.warn(stringBuilder.toString());
        }
    }

    private static String stackTraceToString(StackTraceElement[] stackTraceElementArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            String string = "    ";
            stringBuilder.append("\n").append(string).append(stackTraceElement);
        }
        return stringBuilder.toString();
    }

    private static synchronized int getNewHangNumber() {
        return ++hangCount;
    }

    private class HangChecker
    extends TimerTask {
        private HangChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedList linkedList = EventDispatchThreadHangMonitor.this.dispatches;
            synchronized (linkedList) {
                if (EventDispatchThreadHangMonitor.this.dispatches.isEmpty() || !EventDispatchThreadHangMonitor.this.haveShownSomeComponent) {
                    return;
                }
                ((DispatchInfo)EventDispatchThreadHangMonitor.this.dispatches.getLast()).checkForHang();
            }
        }
    }

    private static class DispatchInfo {
        private StackTraceElement[] lastReportedStack;
        private int hangNumber;
        private final Thread eventDispatchThread = Thread.currentThread();
        private long lastDispatchTimeMillis = System.currentTimeMillis();
        private final long timeout;

        public DispatchInfo(long l) {
            this.timeout = l;
        }

        public void checkForHang() {
            if (this.timeSoFar() > this.timeout) {
                this.examineHang();
            }
        }

        private static boolean stackTraceElementIs(StackTraceElement stackTraceElement, String string, String string2, boolean bl) {
            return stackTraceElement.getClassName().equals(string) && stackTraceElement.getMethodName().equals(string2) && stackTraceElement.isNativeMethod() == bl;
        }

        private boolean isWaitingForNextEvent(StackTraceElement[] stackTraceElementArray) {
            return DispatchInfo.stackTraceElementIs(stackTraceElementArray[0], "java.lang.Object", "wait", true) && DispatchInfo.stackTraceElementIs(stackTraceElementArray[1], "java.lang.Object", "wait", false) && DispatchInfo.stackTraceElementIs(stackTraceElementArray[2], "java.awt.EventQueue", "getNextEvent", false);
        }

        private void examineHang() {
            StackTraceElement[] stackTraceElementArray = GriffonExceptionHandler.sanitize((StackTraceElement[])this.eventDispatchThread.getStackTrace());
            if (this.isWaitingForNextEvent(stackTraceElementArray)) {
                return;
            }
            if (DispatchInfo.stacksEqual(this.lastReportedStack, stackTraceElementArray)) {
                return;
            }
            this.hangNumber = EventDispatchThreadHangMonitor.getNewHangNumber();
            String string = EventDispatchThreadHangMonitor.stackTraceToString(stackTraceElementArray);
            this.lastReportedStack = stackTraceElementArray;
            if (LOG.isWarnEnabled()) {
                LOG.warn("(hang #" + this.hangNumber + ") event dispatch thread stuck processing event for " + this.timeSoFar() + " ms:" + string);
            }
            EventDispatchThreadHangMonitor.checkForDeadlock();
        }

        private static boolean stacksEqual(StackTraceElement[] stackTraceElementArray, StackTraceElement[] stackTraceElementArray2) {
            if (stackTraceElementArray == null) {
                return false;
            }
            if (stackTraceElementArray.length != stackTraceElementArray2.length) {
                return false;
            }
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                if (stackTraceElementArray[i].equals(stackTraceElementArray2[i])) continue;
                return false;
            }
            return true;
        }

        private long timeSoFar() {
            return System.currentTimeMillis() - this.lastDispatchTimeMillis;
        }

        public void dispose() {
            if (this.lastReportedStack != null && LOG.isWarnEnabled()) {
                LOG.warn("(hang #" + this.hangNumber + ") event dispatch thread unstuck after " + this.timeSoFar() + " ms.");
            }
        }
    }
}

