#ifndef FCDSRVCOMM
#define FCDSRVCOMM
/*******************************************************************************
* E.S.O. - VLT project
*
* "@(#) $Id: fcdNoVltSrvCOMM.h,v 1.1 1998/11/25 07:24:09 vltsccm Exp $"
*
* who       when      what
* --------  --------  ----------------------------------------------
* abalestr  24/03/98  created
*/

/************************************************************************
 *
 *----------------------------------------------------------------------
 */

#ifndef __cplusplus
#error This is a C++ include file and cannot be used from plain C
#endif

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/time.h>

// For Solaris...
#ifndef	FD_SETSIZE
#include	<sys/select.h>
#endif

#include <ccs.h>
#include <fcd.h>
#include <fcdWsInternal.h>
#include <fcdSOCK.h>
#include <fcdNoVltSrvMSG.h>
#include <fcdNoVltIf.h>

#define FCDNOACTIV	-1

class fcdNoVltSrvCOMM
{
public:

  fcdNoVltSrvCOMM(char const *);

  ~fcdNoVltSrvCOMM();
  
  ccsCOMPL_STAT manageConnection(ccsPROCNAME *);

private:

  int headLen;			// Size of header
  int servSock;			// Server socket descriptor
  int connSock;			// Connection socket descriptor
  serverTypes connType;		// Connection type
  struct iovec iov[2];		// iovec structure for messages
  fd_set rdwsds;		// For select use
  char remHost[MAXHOSTNAMELEN];	// Remote host name
  ccsERROR error;		// Error structure
  fcdSOCK connection;		// Object to handle the connection
  fcdNoVltSrvMSG message;	// Object to handle messages

  ccsCOMPL_STAT manageMessage();
  void closeConnection();
};

#endif /*!FCDSRVCOMM*/
