/*******************************************************************************
* E.S.O. - VLT project
*
* "@(#) $Id: fcdNoVltSrvCOMM.C,v 1.1 1998/11/25 07:24:10 vltsccm Exp $"
*
* who       when      what
* --------  --------  ----------------------------------------------
* abalestr  03/04/98  created 
*/

/************************************************************************
*   NAME
*   
* 
*   SYNOPSIS
*
*   
*   PARENT CLASS
*
* 
*   DESCRIPTION
*
*
*   PUBLIC METHODS
*
*
*   PUBLIC DATA MEMBERS
*
*
*   PROTECTED METHODS
*
*
*   PROTECTED DATA MEMBERS
*
*
*   PRIVATE METHODS
*
*
*   PRIVATE DATA MEMBERS
*
*
*   FILES
*
*   ENVIRONMENT
*
*   COMMANDS
*
*   RETURN VALUES
*
*   CAUTIONS 
*
*   EXAMPLES
*
*   SEE ALSO
*
*   BUGS   
* 
*------------------------------------------------------------------------
*/

#define _POSIX_SOURCE 1
#include "vltPort.h"

static char *rcsId="@(#) $Id: fcdNoVltSrvCOMM.C,v 1.1 1998/11/25 07:24:10 vltsccm Exp $"; 
static void *use_rcsId = ((void)&use_rcsId,(void *) &rcsId);

#include <fcdNoVltSrvCOMM.h>

fcdNoVltSrvCOMM::fcdNoVltSrvCOMM(char const *service) {
  if (connection.InitServer(servSock, service) != SUCCESS) {
    errAdd(fcdMODULE, fcdERR_GENERIC, __FILE_LINE__, 
	   "Failed to init server");
    errCloseStack();
    exit(1);
  }
  connSock = FCDNOACTIV;
}

fcdNoVltSrvCOMM::~fcdNoVltSrvCOMM() {
}

ccsCOMPL_STAT fcdNoVltSrvCOMM::manageConnection(ccsPROCNAME *procName) 
{
  for (;;) {
    FD_ZERO (&rdwsds);
    if (servSock != FCDNOACTIV)
      FD_SET (servSock, &rdwsds);
    if (connSock != FCDNOACTIV)
      FD_SET (connSock, &rdwsds);

    if (select (FD_SETSIZE, &rdwsds, NULL, NULL, NULL) < 0 && errno != EBADF) {
      errAdd(fcdMODULE, fcdERR_GENERIC, __FILE_LINE__, "Error in select");
      return(FAILURE);
    }

    if (servSock != FCDNOACTIV && FD_ISSET (servSock, &rdwsds)) {
      // It's a new connection...
      // Connect...
      if (connection.Connect(servSock, connSock, remHost) != SUCCESS) {
        errAdd(fcdMODULE, fcdERR_GENERIC, __FILE_LINE__, "Failed to connect");
        return(FAILURE);
      }
      // Time to fork...
      if (fork() != 0) {
	// we are the parent...
	// Close the connected socket...
	close(connSock);
        connSock = FCDNOACTIV;
	// and continue...
	continue;
      } 
      else {
	// We are the child: do the job!
	ccsPROCNAME childName;
	sprintf(childName, "%s_%d", (char *)procName, (int)getpid());
	if (ccsInit(childName) != SUCCESS) {
     	  exit(1);
	}

	// Now we can close the accept descriptor...
	close(servSock);
	servSock = FCDNOACTIV;
        // Handshake on the purpose of the connection...
        if (connection.Receive(connSock, (char *)&connType, 
	                       sizeof(serverTypes)) != SUCCESS) {
	  closeConnection();
        }
        continue;
      }
    }
    else {
      // A message has arrived...
      if (manageMessage() != SUCCESS) {
        errAdd(fcdMODULE, fcdERR_GENERIC, __FILE_LINE__, 
	       "Error managing message");
        return(FAILURE);
      }
    }
  }

  return(SUCCESS);
}

ccsCOMPL_STAT fcdNoVltSrvCOMM::manageMessage() 
{
 
    if (FD_ISSET (connSock, &rdwsds)) {
      // If it's a command...
      if (connType == FCDMSGSERVER) {

        // what do we need?
        msgMESSAGE msg;
	fcdSrvMsg msgStruct;

	// receive first part
        if (connection.Receive(connSock, (char *)&msgStruct, 
	                       (const int)sizeof(fcdSrvMsg)) != SUCCESS) {
	  closeConnection();
	}

	// allocate space for the buffer
	char *locBuffer = new char [msgStruct.buflen];
	// receive second part
        if (connection.Receive(connSock, locBuffer, 
	                       (const int)msgStruct.buflen) != SUCCESS) {
	   closeConnection();
	  
	}

       
	printf("Command = %s\n",msgStruct.command);
	printf("Parameter = %s\n",locBuffer);
	
        // send the command
        if ((msgStruct.status = message.Call(msg, msgStruct.command, locBuffer, 
	                                     msgStruct.destenv, 
					     msgStruct.destproc, 
				             msgStruct.timeout)) != SUCCESS) {

          errAdd(fcdMODULE, fcdERR_GENERIC, __FILE_LINE__, 
	         "Failure sending command");
	}
	
	


        // prepare the reply
        iov[0].iov_base = (char *)&msgStruct;
        iov[0].iov_len = sizeof(fcdSrvMsg);
        msgStruct.buflen = msg.Buflen();
        iov[1].iov_base = (char *)msg.Buffer();
        iov[1].iov_len = msgStruct.buflen;


	printf("return = %s\n",msg.Buffer());

	
        // send the reply
        if (connection.Send(connSock, &iov[0], 2) != SUCCESS) {
          errAdd(fcdMODULE, fcdERR_GENERIC, __FILE_LINE__, 
    	         "Failed to send reply back");
	  closeConnection();
        }

	

	// destroy buffer
	delete [] locBuffer;
      }
      // If it's a db read...
      else if (connType == FCDDBSERVER) {

     
        // what do we need?
        fcdSrvDb dbStruct;

        if (connection.Receive(connSock, (char *)&dbStruct, 
	                       (const int)sizeof(fcdSrvDb)) != SUCCESS) {
	  closeConnection();
	}
	
	// create buffer for data

	char *locBuffer = new char [dbStruct.size];

	printf("DBase read =%s\n",dbStruct.pointName);

        // read from db
        if ((dbStruct.status = dbReadSymbolic(dbStruct.pointName, 
	                                      dbStruct.attrName,
  	                                      dbStruct.dataType, locBuffer, 
			  		      dbStruct.size, &dbStruct.actual, 
					      &dbStruct.recordCnt, 
					      &dbStruct.attrType, 
					      &error)) != SUCCESS) {
          errAdd(fcdMODULE, fcdERR_GENERIC, __FILE_LINE__, 
	         "Failure reading database");
	}

        // prepare the reply
	
	// data buffer
        iov[0].iov_base = (char *)&dbStruct;
        iov[0].iov_len = sizeof(fcdSrvDb);
        iov[1].iov_base = locBuffer;
        iov[1].iov_len = dbStruct.size;


	// error structure
        memcpy(&dbStruct.error, &error, sizeof(ccsERROR_mod));

        // send the reply
        if (connection.Send(connSock, &iov[0], 2) != SUCCESS) {
          errAdd(fcdMODULE, fcdERR_GENERIC, __FILE_LINE__, "Failed to send");
	  closeConnection();
        }
	
	// destroy buffer
	delete [] locBuffer;
      }
      else {
        errAdd(fcdMODULE, fcdERR_GENERIC, __FILE_LINE__, "Unknown packet type");
        return(FAILURE);
      }
    }
  return(SUCCESS);
}

void fcdNoVltSrvCOMM::closeConnection() {
  close(connSock);
  exit(1);
}

/*___oOo___*/
