/*******************************************************************************
* E.S.O. - VLT project
*
* "@(#) $Id: fcdNoVltSrvMSG.C,v 1.1 1998/11/25 07:24:11 vltsccm Exp $"
*
* who       when      what
* --------  --------  ----------------------------------------------
* rdonalds  01/05/96  created 
* abalestr  24/04/98  modified for testbench 
*/

/************************************************************************
*   NAME
*   
* 
*   SYNOPSIS
*
*   
*   PARENT CLASS
*
* 
*   DESCRIPTION
*
*
*   PUBLIC METHODS
*
*
*   PUBLIC DATA MEMBERS
*
*
*   PROTECTED METHODS
*
*
*   PROTECTED DATA MEMBERS
*
*
*   PRIVATE METHODS
*
*
*   PRIVATE DATA MEMBERS
*
*
*   FILES
*
*   ENVIRONMENT
*
*   COMMANDS
*
*   RETURN VALUES
*
*   CAUTIONS 
*
*   EXAMPLES
*
*   SEE ALSO
*
*   BUGS   
* 
*------------------------------------------------------------------------
*/

#define _POSIX_SOURCE 1
#include "vltPort.h"

static char *rcsId="@(#) $Id: fcdNoVltSrvMSG.C,v 1.1 1998/11/25 07:24:11 vltsccm Exp $"; 
static void *use_rcsId = ((void)&use_rcsId,(void *) &rcsId);

// Include files for ECCS and Evh Toolkit
#include "ECCS.h"

#include <fcdNoVltSrvMSG.h>

fcdNoVltSrvMSG::fcdNoVltSrvMSG () {}
fcdNoVltSrvMSG::~fcdNoVltSrvMSG () {}
/*
 *# Call 
 *#
 *# 
 */
ccsCOMPL_STAT fcdNoVltSrvMSG::Call(msgMESSAGE &msg, msgTIMEOUT timeout)
{
    ccsCOMPL_STAT stat;

    // Set up a filter so we only get replies for what we want
    msgRECEIVEFILTER msgFilter;
    if (msgSetFilter (msg.Destenv(), msg.Destproc(), msgREPLY_FOR_CMD,
		      msg.CommandId(), (char *)msg.Command(), 
		      &msgFilter, 0) == FAILURE) {
    printf("process does not exist\n");
	errAdd (fcdMODULE, fcdERR_GENERIC_STR, __FILE_LINE__,
				"Process does not exist", msg.Destproc());
	return (FAILURE);
	}


    // Send the command
    if ((stat = msg.SendCommand(0 /* no check */)) == FAILURE) {
	errAdd (fcdMODULE, fcdERR_GENERIC_STR2, __FILE_LINE__,
		"Failed to send command",
		(char *)msg.Command(), msg.Destproc()); return (FAILURE);
	}

    // Loop on replies
    for (;;) {
      // Receive the reply
      if ((stat = msg.Receive(timeout, &msgFilter)) == FAILURE) {
	printf("reply time out \n"); 
      errAdd (fcdMODULE, fcdERR_GENERIC_STR, __FILE_LINE__,
		  "Reply timed out from", msg.Destproc());
	  return (FAILURE);
	  }

      // Check for error reply
      if (msg.Type() == msgTYPE_ERROR_REPLY) {
	  errAdd (fcdMODULE, fcdERR_GENERIC_STR, __FILE_LINE__,
		  "Receive error reply from", msg.Destproc());
	  printf("error reply \n");
	  return (FAILURE);
	  }

      // Check for last reply
      if (msg.LastReply() == ccsTRUE) {
	// Last reply
	break;
      }
    }
    
    return stat;
}

/*
 *# Call 
 *#
 *# 
 */
ccsCOMPL_STAT fcdNoVltSrvMSG::Call (
		      		    msgMESSAGE		&msg,
		      		    char		*command,
		      		    char		*buffer,
		      		    char		*env,
		      		    char		*proc,
		      		    msgTIMEOUT		tmoInMSecs
		      		    )
{
  msg.Command (command);
  msg.Buffer (buffer);
  msg.Destenv (env);
  msg.Destproc (proc);

  return (Call (msg, tmoInMSecs));
}
/*___oOo___*/
