//KE486 driver
//purpose : this unit is an high level interface to access to the ammeter ke486 on the CCD test bench
//at first, initialize the device by calling the init function 


#include "ugpib.h"
#include <iostream.h>

#ifndef __Ke486drv
#define __Ke486drv


class Ke486 {
  public:
    Ke486();
    Ke486(ostream * outputS);
    ~Ke486();

    int init();
    int setFilter(int Func);
    int setRange(int Func);
    int setIntegration(int Func);
    int setReadoutDelay(float delay);
    int setTrigger(int Func);
    int measure(int Func,float &value);
    int mesureSerie(int Func, int NumberOfPoints, float Interval, float *DataArray);
    int getMesureSerieBuffer(int nbRead,float *DataArray); 

    void setOutPutStream(ostream * outputS);

    char * getErrorString(int errorCode,char * errorString);
  protected:
    //Handle of the device
    int device;

    ostream * outputS;
    int readBuffer(char *cmd,int cnt);
    int writeBuffer(char *cmd,int cnt);
    int check(int Mask);
    int makeZeroCheck(int Func);
    int errorIdent();
    displayMessage(char * message);
};


#endif
