/*---------------------------------------*/
/* Oriel MS257 Include File              */
/* Author: Paola Amico 					 */
/* Date:   February 1998     			 */
/*---------------------------------------*/

#ifndef __ms257_HEADER
#define __ms257_HEADER
#define E101	"GPIB error: OpenDevice Ms257_1 failed"
#define E201	"GPIB error: OpenDevice Ms257_2 failed"
#define E102	"GPIB error: Clear device Ms257_1 failed (ibclr function)"
#define E202	"GPIB error: Clear device Ms257_2 failed (ibclr function)"
#define E120	"MS257 error: device failing - check error string"
#define E1111   "GPIB error: read error Ms257_1 (ibrd function)"
#define E2111   "GPIB error: read error Ms257_2 (ibrd function)"
#define E311	"Input error (Ms257): flag is wrong in read data function (must be 0,1 or 2)"
#define E3		"Scan error: output string from Ms257 incorrect"
#define E4		"Byte-count-error: no bytes scanned (Ms257)"
#define E13		"Error: Ms257 can not be closed - invalid identifier"
#define E16		"GPIB error: Ms257_1 can not be put in local (ibloc function)"
#define E26		"GPIB error: Ms257_2 can not be put in local (ibloc function)"
#define E17		"GPIB error: Ms257_1 not found in table of opened devices"
#define E27		"GPIB error: Ms257_2 not found in table of opened devices"
#define E12		"GPIB error: Ms257_1 not cleared (ibclr function)"
#define E22		"GPIB error: Ms257_1 not cleared (ibclr function)"
#define E99		"Input error (Ms257): flag is wrong in set slit function (must be 1,2, or 3)"
#define E333	"Input error (Ms257): flag is wrong in query function (parameter not coded)"
#define E112	"GPIB error: write error Ms257_1 (ibwrt function)"
#define E212	"GPIB error: write error Ms257_2 (ibwrt function)"
#define E312	"Input error (MS257): flag is wrong in write data function (must be 0,1 or 2)"
#define E14		"Input error (MS257): invalid integer range"
#define E15		"Input error (MS257): invalid real range"
#define def		"Error (Ms257): invalid Error number"


#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif


/*****************************************************************************/
/*  GLOBAL USER-CALLABLE FUNCTION DECLARATIONS (Exportable Functions)        */
/*****************************************************************************/

/*---------Start/End functions------------*/

int ms257_init(void);

int ms257_close(void);

/*---------Configure functions------------*/

int ms257_set_slit(int Flag,double Width); 

int ms257_set_bandpass(double Value);

int ms257_send_sequence(int Flag, char *Sequence, char *StatusArray);

int ms257_set_filter(int Flag, int Func);

int ms257_setPortOutPut(void);   
int ms257_setPortSphere(void); 



/*---------Operation functions------------*/

int ms257_go_wave(int Flag,double Wave);

int ms257_shutter(int Func);



/*---------Utility functions-------------*/

int ms257_clear(void);

int ms257_query(int Flag, int Func, char *Query);     

int ms257_error_id(int ms257_err, char *errormessage);

/*****************************************************************************/
/*END of GLOBAL USER-CALLABLE FUNCTION DECLARATIONS                          */
/*****************************************************************************/

#if defined(__cplusplus) || defined(__cplusplus__)
}
#endif

/*****************************************************************************/
/* END INCLUDE FILE                                                           */
/*****************************************************************************/

#endif
