// E.S.O.
// bgaillar  20/10/99  created 
//

// E.S.O.
// bgaillar  20/10/99  created
//
//
// ms257 driver
//purpose : this unit is an high level interface to access to the monochromator
//ms257 on the CCD test bench
//At first, initialize the device by calling the init function 
//
// init                  Initialize the monochromator
//
//  setWavelength        Position the current grating to the current wavelength
//                       Wavelength must be within the range 0 to MAXW
//
// setPortout            Select input port (B,C)
//
// setBandpass           Bandpath in NM.
//
// setFilter             Select position of filter wheel 1, in front of the 
//                       monochromator. Value beetween 1 and 5.      
//
// setShutter            Set the shutter state (1: open, 0: close)
//
// setOutPutStream       Set the ouput standard message stream.NULL if
//                       no message. 


#include "ugpib.h"
#include <iostream.h>

#ifndef __Ms257drv
#define __Ms257drv

class Ms257 {
  public:
    Ms257();
    Ms257(ostream * outpusS);
    ~Ms257();
    
    int init();
    int setWavelength(float wavelength);
    int setPortout(char port);
    int setBandpass(float bandpass);
    int setFilter(int filterNumber);
    int setShutter(int shutterState);

    void setOutPutStream(ostream * outputS);

    char * getErrorString(int errorCode,char * errorString);
  private:
    //Handles of the devices
    int device1;
    int device2;  
    
    float maxW;
    
    ostream * outputS;

    int readBuffer(int dev, char *string,int & cnt);
    int writeBuffer(int dev,char *string,int cnt);  
};


#endif
