#!/bin/sh
# Define which version of the sequencer to use \
  exec seqWish "$0"  ${1+"$@"}
#
#*************************************************************
# E.S.O. - VLT project
#
# "@(#) $Id$" 
#
# panel.pan
#
# This file has been produced by the panel editor
#   version: panel.tcl,v 4.16
#   date   : Wed Nov 10 17:07:18 MET 1999
#
#      !!!!!!!!!!  DO NOT MANUALLY EDIT THIS FILE  !!!!!!!!! 
#
#--------------------------------------------------------------
#
global par gvar cv bcv actAreaHeight shArea panClassLib 
global geoCmdReply panClassLib panUsrProcs panUsrLib
global argv0 env panWidget panWidgetHlp panDbData cwp ckHeartBeat
global menu menuBar menuHelp ckMenuBar ckActBut ckShHelp ckCCS
# 
#  Get directory root of VLT, integration, current module. 
global VLTROOT INTROOT HOME

if {[catch {set VLTROOT $env(VLTROOT)}]} {set VLTROOT dummy}
if {[catch {set INTROOT $env(INTROOT)}]} {set INTROOT dummy}
if {[catch {set HOME    $env(HOME)}   ]} {set HOME    dummy}
# 
# Set auto_path 
# 

if { [file exist ../lib/libpanPublic.tcl] } { 
   lappend auto_path ../lib/libpanPublic.tcl
} elseif { [file exist $INTROOT/lib/libpanPublic.tcl ] } { 
   lappend auto_path $INTROOT/lib/libpanPublic.tcl
} elseif { [file exist $VLTROOT/lib/libpanPublic.tcl ] } { 
   lappend auto_path $VLTROOT/lib/libpanPublic.tcl 
} else {
   puts stderr "panel EXITS : Tcl library libpanPublic.tcl not found " 
   exit 1
}

#
# Link panel to user libraries 
#
set panUsrLib   {}  
set panClassLib {}

panSetAutoPath  $panUsrLib $panClassLib 

if {[info exists EDITING]} { 
   set panRoot .panel 
   set panUsrProcs {panelInit panelExit panelInitData panelSendCommandFilter panelSendCommandPort panelSendCommandSerialRead panelSendCommandBufferRead}
   set argc 0 ; set argv {}
} else {
   set par(MY_NAME) [file tail $argv0] 
   set EDITING 0
   set tk_strictMotif 0
   setPublicVar
   set panRoot . 
}

# User's Init Data : called just after panInit
# It contains data to be defined before widgets are created

proc panelInitData {} {

 # Declare global variables

   global lastNbRead

 # Statements to be executed when exiting
   set lastNbRead 0
}



# User's Init Procedure : called in panMainStart
# It is executed after the widgets have been created

proc panelInit {} {

 # Declare global variables

   global env
   global lastNbRead
 # User Initialization
   set lastNbRead 0

   panSendCommand $env(RTAPENV) "fcdtserver" "OINIT" NO_CHECK 60000 ""
   panSendCommand $env(RTAPENV) "fcdtserver" "KINIT" NO_CHECK 60000 ""	
}



#
#-----------------------------------------------
#            Widget Definition  
#-----------------------------------------------
# 

set ckHeartBeat   0 ;# Enable Heart-beat
set ckShHelp      1 ;# Set Short Help
set ckActBut      0 ;# Set Action Button Area
set ckMenuBar     0 ;# Setup Menu Bar
set ckCCS         1 ;# Initialize CCS
set ckCmdReply    1 ;# Display Cmd. Reply
set cwp           "" ;# Set Current Working Point
set par(sizeCmdReply) 6 ;# Size of reply window
set actAreaHeight 5; # Set height of action area 

panReadOption winter
set par(PANELX) 1008 ;# Panel X position
set par(PANELY) -1 ;# Panel Y position
panCreateFrame panel ;# Create empty frame
panGetCvNames  panel cv bcv ;# Get Canvas Names
panInit        $argc $argv panel ;# Initialization



UifEntry           $cv.bandwidth -canvasAnchor nw -default 10 \
                   -label Bandwidth \
                   -labelFont -Adobe-helvetica-medium-r-normal--12* \
                   -labelWidth 0 -maxVal 100 -minVal 0 -units NM \
                   -variable gvar(bandwidth) -width 5
UifOptionButton    $cv.filters -canvasAnchor nw \
                   -command panelSendCommandFilter -default 100% \
                   -itemList {100% 50% 25% 10% 1%} -itemValue {1 4 5 2 3} \
                   -length 5 -selectMode value -variable gvar(filters)
UifButton          $cv.getbuffer -canvasAnchor nw \
                   -command panelSendCommandBufferRead -initialState normal \
                   -label {get Buffer} -popup 0 \
                   -stateVar gvar(panel-wdg63Var) -width 0
UifEntry           $cv.inttime -canvasAnchor nw -default 0.02 \
                   -label {Integration time} \
                   -labelFont -Adobe-helvetica-medium-r-normal--12* \
                   -labelWidth 0 -maxVal 100 -minVal 0 \
                   -variable gvar(inttime) -width 5
UifEntry           $cv.kindReading -canvasAnchor nw -default 4 \
                   -label Function \
                   -labelFont -Adobe-helvetica-medium-r-normal--12* \
                   -labelWidth 0 -maxVal 8 -minVal 1 \
                   -variable gvar(kindReading) -width 5
UifEntry           $cv.nbmesure -canvasAnchor nw -default 10 \
                   -label {Mesure number} \
                   -labelFont -Adobe-helvetica-medium-r-normal--12* \
                   -labelWidth 0 -maxVal 511 -minVal 0 \
                   -variable gvar(nbmesure) -width 5
UifButton          $cv.panel-wdg1 -canvasAnchor nw \
                   -command {panSendCommand $env(RTAPENV) "fcdtserver" "OSWAV" NO_CHECK 60000 $gvar(wavelength)} \
                   -initialState normal -label Apply... -popup 0 \
                   -stateVar gvar(panel-wdg37Var) -width 0
UifButton          $cv.panel-wdg2 -canvasAnchor nw \
                   -command {panSendCommand $env(RTAPENV) "fcdtserver" "OSBP" NO_CHECK 60000 $gvar(bandwidth)} \
                   -initialState normal -label Apply... -popup 0 \
                   -stateVar gvar(panel-wdg53Var) -width 0
UifButton          $cv.panel-wdg3 -canvasAnchor nw \
                   -command {panelSendCommandSerialRead $gvar(kindReading) $gvar(nbmesure) $gvar(inttime)} \
                   -initialState normal -label get... -popup 0 \
                   -stateVar gvar(panel-wdg57Var) -width 0
UifOptionButton    $cv.portout -canvasAnchor nw \
                   -command panelSendCommandPort -default B \
                   -itemList {Sphere Output} -itemValue {B C} -length 5 \
                   -selectMode value -variable gvar(portout)
UifCheckButton     $cv.shutter -anchor w -canvasAnchor nw \
                   -command {panSendCommand $env(RTAPENV) "fcdtserver" "OSSHUT" NO_CHECK 60000 $gvar(shutter)} \
                   -default 1 -label Shutter -offVal 0 -onVal 1 \
                   -variable gvar(shutter) -width 0
UifButton          $cv.starttrigger -canvasAnchor nw \
                   -command {panelSendCommandSerialRead 6 $gvar(nbmesure) $gvar(inttime)} \
                   -initialState normal -label {Start trigger} -popup 0 \
                   -stateVar gvar(panel-wdg62Var) -width 0
UifEntry           $cv.wavelength -canvasAnchor nw -default 632 \
                   -label Wavelength \
                   -labelFont -Adobe-helvetica-medium-r-normal--12* \
                   -labelWidth 10 -maxVal 2000 -minVal 0 -units NM \
                   -variable gvar(wavelength) -width 5

#
#  Canvas Items
#

$cv create text 28 104 -tags "text panel-item1" -anchor nw \
          -text "Neutral density filters (T%) :" \
          -fill black -font -Adobe-helvetica-medium-r-normal--12* 

$cv create text 96 -4 -tags "text panel-item2" -anchor nw \
          -text "Monochromator (ms257)" \
          -fill black -font -Adobe-helvetica-bold-r-normal--14* 

$cv create text 28 132 -tags "text panel-item3" -anchor nw \
          -text "Output Monochromator port :" \
          -fill black -font -Adobe-helvetica-medium-r-normal--12* 

$cv create text 356 -4 -tags "text panel-item4" -anchor nw \
          -text "Ammeter (ke486)" \
          -fill black -font -Adobe-helvetica-bold-r-normal--14* 


#
# Set Widget Configuration
#
set panWidget(bandwidth)  {UifEntry 24 68 1 0 10 0 0 bandwidth 0 N 0 100 0 0 0 0}
set panWidget(filters)  {UifOptionButton 192 96 1 0 100% 0 0 filters 0 {}}
set panWidget(getbuffer)  {UifButton 536 136 1 0 0 0 0 {} 0 {}}
set panWidget(inttime)  {UifEntry 344 84 1 0 0.02 0 0 inttime 0 N 0 100 0 0 0 0}
set panWidget(kindReading)  {UifEntry 356 36 1 0 4 0 0 kindReading 0 N 1 8 0 0 0 0}
set panWidget(nbmesure)  {UifEntry 344 60 1 0 10 0 0 nbmesure 0 N 0 511 0 0 0 0}
set panWidget(panel-wdg1)  {UifButton 192 36 1 0 0 0 0 {} 0 {}}
set panWidget(panel-wdg2)  {UifButton 192 64 1 0 0 0 0 {} 0 {}}
set panWidget(panel-wdg3)  {UifButton 516 52 1 0 0 0 0 {} 0 {}}
set panWidget(portout)  {UifOptionButton 192 124 1 0 B 0 0 portout 0 {}}
set panWidget(shutter)  {UifCheckButton 120 168 1 0 1 0 0 shutter 0 0 1 0 0 0}
set panWidget(starttrigger)  {UifButton 448 136 1 0 0 0 0 {} 0 {}}
set panWidget(wavelength)  {UifEntry 24 40 1 0 632 0 0 wavelength 0 N 0 2000 0 0 0 0}

#
# Set Database Configuration
#

#
# Set Short Help for each widget
#
set panWidgetHlp(bandwidth)  {Banpath width}
set panWidgetHlp(filters)  {Set neutral filter}
set panWidgetHlp(inttime)  {Integration time}
set panWidgetHlp(kindReading)  {Readout type}
set panWidgetHlp(nbmesure)  {Mesure number. More accurate for a high number}
set panWidgetHlp(panel-wdg1)  {Positions the grating to the desired wavelength}
set panWidgetHlp(panel-wdg2)  {Set the bandpath to the desired width}
set panWidgetHlp(panel-wdg3)  {Query a mesure}
set panWidgetHlp(portout)  {Set ouput monochromator 2}
set panWidgetHlp(shutter)  {Activate shutter (ON value=Shutter closed)}
set panWidgetHlp(wavelength)  {Desired wavelength}

#
#-----------------------------------------------
#            Create the Panel  
#-----------------------------------------------
#

wm geometry  $panRoot 615x397
wm title     $panRoot "FIERA - MS Engineering"
set par(TITLE) "FIERA - MS Engineering" 

panMainStart  panel $argc $argv

#--------------------    End of Main   --------------------



#####################################################
#           Definition of Local Procedures
#####################################################


proc panelExit {} {

 # Declare global variables

   global <var>

 # Statements to be executed when exiting
}


proc panelSendCommandFilter {filter} {

   global cv
   global gvar
   global env

   panSendCommand $env(RTAPENV) "fcdtserver" "OSFILT" NO_CHECK 60000 $filter	
}


proc panelSendCommandPort {port} {

   global cv
   global gvar
   global env

   panSendCommand $env(RTAPENV) "fcdtserver" "OSPORT" NO_CHECK 60000 $port	
}


proc panelSendCommandSerialRead {kindReading nbRead inttime} {



   global cv
   global gvar
   global env
   global lastNbRead
   set lastNbRead $nbRead

   panSendCommand $env(RTAPENV) "fcdtserver" "KSM" NO_CHECK 60000 $kindReading $nbRead $inttime	
}


proc panelSendCommandBufferRead {} {



   global cv
   global gvar
   global env
   global lastNbRead

   if {$lastNbRead>1} {
    panSendCommand $env(RTAPENV) "fcdtserver" "KGB" NO_CHECK 60000 $lastNbRead	
    set lastNbRead 0
   }
}
