// E.S.O.
// bgaillar  20/10/99  created 
//
//   DESCRIPTION
//   This unit is an interface between the standard VLT message
//   system and the ke486 ammeter. See the ke486 doc and the ke486drv.c file
//   to have more information.
//   The creation of this class reinit the ammeter (constructor)
//   the available messages are :
//   Message           Parameters
//   KINIT             None                  Initialisation
//   KSM               Mesure function,nbsample,integrationtime   Request a mesure serial.
//   KS                Mesure function       Requests a mesure
//   KGB               NbMesure              Requests the mesure serial in 
//                                           the buffer 
//   KSTRIG            delayTime             Sets the trigger delay time
//   KSROUT            ReadOutDelay          Sets the readOut delay time
//   KSIP              IntegrationPeriod     Sets the intergation period
//   KSRANGE           range                 Sets the current measurement range
//   KSFILT            filter                Sets the filter type on the 
//                                           input signal


                        
#include <stdlib.h>
#include "fcdtTaskke486.h"

Keithley::Keithley(int debugMode) {
    
   int errorCode=0;
   char errorString[255]; 
    

   ke486=new Ke486(&cout);
   
   if ((errorCode=ke486->init())!=0) {
   printf("ke486 init error ->  %s\n",ke486->getErrorString(errorCode,errorString));
   delete ke486;
   ke486=NULL;
   //ccsExit();
   //exit(0);	
   return;
   }
   if (debugMode==0)
       ke486->setOutPutStream(NULL);
   

   //We are not initialized
   
   evhMSG_TYPE_KEY keyInit(msgTYPE_COMMAND,"KINIT");
   evhOBJ_CALLBACK cbInit(this,(evhCB_METHOD)init);
   evhMSG_TYPE_KEY keySerialMesure(msgTYPE_COMMAND,"KSM");
   evhOBJ_CALLBACK cbSerialMesure(this,(evhCB_METHOD)serialMesure);
   evhMSG_TYPE_KEY keyMesure(msgTYPE_COMMAND,"KM");
   evhOBJ_CALLBACK cbMesure(this,(evhCB_METHOD)mesure);
   evhMSG_TYPE_KEY keyBuffer(msgTYPE_COMMAND,"KGB");
   evhOBJ_CALLBACK cbBuffer(this,(evhCB_METHOD)getBuffer);
   evhMSG_TYPE_KEY keySetTrigger(msgTYPE_COMMAND,"KSTRIG");
   evhOBJ_CALLBACK cbSetTrigger(this,(evhCB_METHOD)setTriggerMode);
   evhMSG_TYPE_KEY keySetReadOutDelay(msgTYPE_COMMAND,"KSROUT");
   evhOBJ_CALLBACK cbSetReadOutDelay(this,(evhCB_METHOD)setReadOutDelay);
   evhMSG_TYPE_KEY keySetIntegrationPeriod(msgTYPE_COMMAND,"KSIP");
   evhOBJ_CALLBACK cbSetIntegrationPeriod(this,(evhCB_METHOD)setIntegrationPeriod);
   evhMSG_TYPE_KEY keySetRange(msgTYPE_COMMAND,"KSRANGE");
   evhOBJ_CALLBACK cbSetRange(this,(evhCB_METHOD)setRange);
   evhMSG_TYPE_KEY keySetFilter(msgTYPE_COMMAND,"KSFILT");
   evhOBJ_CALLBACK cbSetFilter(this,(evhCB_METHOD)setFilter);
       

   evhHandler->AddCallback(keyInit,cbInit);
   evhHandler->AddCallback(keyMesure,cbMesure);
   evhHandler->AddCallback(keySerialMesure,cbSerialMesure);
   evhHandler->AddCallback(keyBuffer,cbBuffer);
   evhHandler->AddCallback(keySetTrigger,cbSetTrigger);
   evhHandler->AddCallback(keySetReadOutDelay,cbSetReadOutDelay);
   evhHandler->AddCallback(keySetRange,cbSetRange);
   evhHandler->AddCallback(keySetFilter,cbSetFilter);
   evhHandler->AddCallback(keySetIntegrationPeriod,cbSetIntegrationPeriod);
}


Keithley::~Keithley() {
    delete ke486;  
}


evhCB_COMPL_STAT Keithley::init(msgMESSAGE &msg, void *udate) {
    int errorCode=0;
    char errorString[255];
    
    msg.LastReply(ccsTRUE);
    if (ke486==NULL) 
	msg.Buffer("ERROR : ke486 not opened !");
    else {
    if ((errorCode=ke486->init())!=0)
	msg.Buffer(ke486->getErrorString(errorCode,errorString));
    else
	msg.Buffer("OK");
    }
    msg.SendReply();
    return evhCB_NO_DELETE;
    USE(udate);
}


evhCB_COMPL_STAT Keithley::mesure(msgMESSAGE &msg, void *udate) {
    int func;
    float value;
    char interStr[256];

    int errorCode=0;
    char errorString[256];
    
    msg.LastReply(ccsTRUE);
    if (ke486==NULL) 
    //send back the reply
    msg.Buffer("ERROR : ke486 not opened !");
    
    else 
	
	if (sscanf(msg.Buffer(),"%d",&func)!=1)
	    msg.Buffer("ERROR : illegal parameter !");
	else {
	if ((errorCode=ke486->measure(func,value))!=0)
	    msg.Buffer(ke486->getErrorString(errorCode,errorString));
	else{
	sprintf(interStr,"%G",value);
	//send back the reply
	msg.Buffer(interStr);
	}
	}
    
    msg.SendReply();
    
    return evhCB_NO_DELETE;
    USE(udate);
}
    
evhCB_COMPL_STAT Keithley::serialMesure(msgMESSAGE &msg, void *udate) {
    int func,numberOfPoints;
    float interval;
    float * dataArray;
    float mean;
    char interStr[256];
    int i;
    int errorCode=0;
    char errorString[256];

    msg.LastReply(ccsTRUE);
    if (ke486==NULL) 
    //send back the reply
    msg.Buffer("ERROR : ke486 not opened !");
    
    else {

    if (sscanf(msg.Buffer(),"%d %d %f",&func,&numberOfPoints,&interval)!=3)
	msg.Buffer("ERROR : illegal parameter !");
    else 
	if (numberOfPoints>512)
	    msg.Buffer("ERROR : illegal parameter ! The number of point must be below 512.");
	else{
	
	dataArray=(float *)malloc(sizeof(float)*numberOfPoints);
	
	if ((errorCode=ke486->mesureSerie(func,numberOfPoints,interval,dataArray))!=0)
	    msg.Buffer(ke486->getErrorString(errorCode,errorString));
	else {
	for (i=0,mean=0;i<numberOfPoints;i++)
	    mean+=+dataArray[i];
	mean=mean/numberOfPoints;
	sprintf(interStr,"%G",mean);
	msg.Buffer(interStr);
	}
	
	free(dataArray);    
	//send back the reply
	}
    }
    
    msg.SendReply();
    
    return evhCB_NO_DELETE;
    USE(udate);
}


evhCB_COMPL_STAT Keithley::getBuffer(msgMESSAGE &msg, void *udate) {
    int numberOfPoints;
    float * dataArray;
    float mean;
    char interStr[256];
    int i;
    int errorCode=0;
    char errorString[256]; 

    msg.LastReply(ccsTRUE);
    if (ke486==NULL) 
    //send back the reply
    msg.Buffer("ERROR : ke486 not opened !");
    
    else {

    if (sscanf(msg.Buffer(),"%d",&numberOfPoints)!=1)
	msg.Buffer("ERROR : illegal parameter !");
    else 
	if (numberOfPoints>512)
	    msg.Buffer("ERROR : illegal parameter ! The number of point must be below 512.");
	else{
	
	dataArray=(float *)malloc(sizeof(float)*512);
	if ((errorCode=ke486->getMesureSerieBuffer(numberOfPoints,dataArray))!=0)
	    msg.Buffer(ke486->getErrorString(errorCode,errorString));
	else {
	for (i=0,mean=0;i<numberOfPoints;i++)
	    mean+=+dataArray[i];
	mean=mean/numberOfPoints;
	sprintf(interStr,"%G",mean);
	msg.Buffer(interStr);  
	}
	free(dataArray);    
	}
    }
    
    msg.SendReply();
    
    return evhCB_NO_DELETE;
    USE(udate);
}



evhCB_COMPL_STAT Keithley::setTriggerMode(msgMESSAGE &msg, void *udate) {
    int triggerMode;
    int errorCode=0;
    char errorString[256];

    msg.LastReply(ccsTRUE);
    if (ke486==NULL) 
    //send back the reply
    msg.Buffer("ERROR : ke486 not opened !");
    else {
    if (sscanf(msg.Buffer(),"%d",&triggerMode)!=1)
	msg.Buffer("ERROR : illegal parameter !");
    else 
       	{
	if ((errorCode=ke486->setTrigger(triggerMode))!=0)
	    msg.Buffer(ke486->getErrorString(errorCode,errorString));
	else {
	//send back the reply
	msg.Buffer("OK");
	}
	}
    }
    msg.SendReply();
    
    return evhCB_NO_DELETE;
    USE(udate);
}



evhCB_COMPL_STAT Keithley::setReadOutDelay(msgMESSAGE &msg, void *udate) {
    float readOutDelay;
    int errorCode=0;
    char errorString[256];

    msg.LastReply(ccsTRUE);
    if (ke486==NULL) 
    //send back the reply
    msg.Buffer("ERROR : ke486 not opened !");
    else {
    if (sscanf(msg.Buffer(),"%f",&readOutDelay)!=1)
	msg.Buffer("ERROR : illegal parameter !");
    else 
	{

	if ((errorCode=ke486->setReadoutDelay(readOutDelay))!=0)
	    msg.Buffer(ke486->getErrorString(errorCode,errorString));
	else {	
	//send back the reply
	msg.Buffer("OK");
	}
	}
    }
    msg.SendReply();
    
    return evhCB_NO_DELETE;
    USE(udate);
}

evhCB_COMPL_STAT Keithley::setRange(msgMESSAGE &msg, void *udate) {
    int range;
    int errorCode=0;
    char errorString[256];

    msg.LastReply(ccsTRUE);
    if (ke486==NULL) 
	//send back the reply
	msg.Buffer("ERROR : ke486 not opened !");
    else {
    if (sscanf(msg.Buffer(),"%i",&range)!=1)
	msg.Buffer("ERROR : illegal parameter !");
    else 
	{
	if ((errorCode=ke486->setFilter(range))!=0)
	    msg.Buffer(ke486->getErrorString(errorCode,errorString));
	else {	
	//send back the reply
	msg.Buffer("OK");    
	}
	}
    }
    msg.SendReply();
    
    return evhCB_NO_DELETE;
    USE(udate);
}



evhCB_COMPL_STAT Keithley::setFilter(msgMESSAGE &msg, void *udate) {
    int filter;
    int errorCode=0;
    char errorString[256];

    msg.LastReply(ccsTRUE);
    if (ke486==NULL) 
	//send back the reply
	msg.Buffer("ERROR : ke486 not opened !");
    else {
    if (sscanf(msg.Buffer(),"%i",&filter)!=1)
	msg.Buffer("ERROR : illegal parameter !");
    else 
	{
	if ((errorCode=ke486->setFilter(filter))!=0)
	    msg.Buffer(ke486->getErrorString(errorCode,errorString));
	else {	
       	//send back the reply
	msg.Buffer("OK");
	}
	}
    }
    msg.SendReply();
    
    return evhCB_NO_DELETE;
    USE(udate);
}


evhCB_COMPL_STAT Keithley::setIntegrationPeriod(msgMESSAGE &msg, void *udate) {
    int integrationPeriod;
    int errorCode=0;
    char errorString[256];

    msg.LastReply(ccsTRUE);
    if (ke486==NULL) 
	//send back the reply
	msg.Buffer("ERROR : ke486 not opened !");
    else {
    if (sscanf(msg.Buffer(),"%d",&integrationPeriod)!=1)
	msg.Buffer("ERROR : illegal parameter !");
    else 
	{
	if ((errorCode=ke486->setIntegration(integrationPeriod))!=0)
	    msg.Buffer(ke486->getErrorString(errorCode,errorString));
	else {	
	//send back the reply
	msg.Buffer("OK");
	}
	}
    }
    msg.SendReply();
    
    return evhCB_NO_DELETE;
    USE(udate);
}
