// E.S.O.
// bgaillar  20/10/99  created 
//
//   DESCRIPTION
//   This unit is an interface between the standard VLT message
//   system and the ke6514 ammeter. See the ke6514 doc and the ke6514drv.c file
//   to have more information.
//   The creation of this class reinit the ammeter (constructor)
//   the available messages are :
//   Message           Parameters
//   KINIT             None                  Initialisation
//   KSM               Mesure function,nbsample,integrationtime   Request a mesure serial.
                        
#include <stdlib.h>
#include "fcdtTaskke6514.h"

Keithley6514::Keithley6514(int debugMode) {
    
   int errorCode=0;
   char errorString[255]; 
    

   ke6514=new Ke6514(&cout);
   
   if ((errorCode=ke6514->init())!=0) {
   printf("ke6514 init error ->  %s\n",ke6514->getErrorString(errorCode,errorString));
   delete ke6514;
   ke6514=NULL;
   //ccsExit();
   //exit(0);
   return;
   }
   if (debugMode==0)
       ke6514->setOutPutStream(NULL);
   

   //We are not initialized
   
   evhMSG_TYPE_KEY keyInit(msgTYPE_COMMAND,"K6INIT");
   evhOBJ_CALLBACK cbInit(this,(evhCB_METHOD)init);
   evhMSG_TYPE_KEY keySerialMesure(msgTYPE_COMMAND,"K6SM");
   evhOBJ_CALLBACK cbSerialMesure(this,(evhCB_METHOD)serialMesure);
       

   evhHandler->AddCallback(keyInit,cbInit);
   evhHandler->AddCallback(keySerialMesure,cbSerialMesure);
}


Keithley6514::~Keithley6514() {
    delete ke6514;  
}


evhCB_COMPL_STAT Keithley6514::init(msgMESSAGE &msg, void *udate) {
    int errorCode=0;
    char errorString[255];
    
    msg.LastReply(ccsTRUE);
    if (ke6514==NULL) 
	msg.Buffer("ERROR : ke6514 not opened !");
    else {
    if ((errorCode=ke6514->init())!=0)
	msg.Buffer(ke6514->getErrorString(errorCode,errorString));
    else
	msg.Buffer("OK");
    }
    msg.SendReply();
    return evhCB_NO_DELETE;
    USE(udate);
}

    
evhCB_COMPL_STAT Keithley6514::serialMesure(msgMESSAGE &msg, void *udate) {
    int numberOfPoints;
    float * dataArray;
    float mean;
    char interStr[256];
    int i;
    int errorCode=0;
    char errorString[256];

    msg.LastReply(ccsTRUE);
    if (ke6514==NULL) 
    //send back the reply
    msg.Buffer("ERROR : ke6514 not opened !");
    
    else {

    if (sscanf(msg.Buffer(),"%d",&numberOfPoints)!=1)
	msg.Buffer("ERROR : illegal parameter !");
    else 
	if (numberOfPoints>512)
	    msg.Buffer("ERROR : illegal parameter ! The number of point must be below 512.");
	else{
	
	dataArray=(float *)malloc(sizeof(float)*numberOfPoints);
	
	if ((errorCode=ke6514->mesureSerie(numberOfPoints,dataArray))!=0)
	    msg.Buffer(ke6514->getErrorString(errorCode,errorString));
	else {
	for (i=0,mean=0;i<numberOfPoints;i++)
	    {
	    mean+=+dataArray[i];
	    printf("%f\n",dataArray[i]);
	    }
	mean=mean/numberOfPoints;
	
	sprintf(interStr,"%G",mean);
	msg.Buffer(interStr);
	}
	
	
	free(dataArray);    
	//send back the reply
	}
    }
    
    msg.SendReply();
    
    return evhCB_NO_DELETE;
    USE(udate);
}

