// E.S.O.
// bgaillar  15/02/00  created 
//   DESCRIPTION
//   This unit is an interface between the standard VLT message
//   system and the MM400 Newport motion controler
//   The creation of this class reinit the motion controler (constructor)
//   the available messages are :
//   Message           Parameters
//   MMINIT            None                     Initialisation
//   MMPA              AxisNumber Position      Move an axis absolutely
//   MMPR              AxisNumber Movement      Move an axis relatively   
//   MMOR              None                     Search for home 
//   MMTP              AxisNumber               Return the current position

#include "fcdtTaskmm4000.h"


MotionControlerMM4000::MotionControlerMM4000(int debugMode) {
    
    int errorCode=0;
    char errorString[255]; 
    

    //initialisation
    _mm4000=new mm4000(&cout);
    if ((errorCode=_mm4000->init())!=0) {
    printf("mm4000 init error ->  %s\n",_mm4000->getErrorString(errorCode,errorString));
    delete _mm4000;
    _mm4000=NULL;    
    //ccsExit();
    //exit(0);	
    return;
    }
    if (debugMode==0)
	_mm4000->setOutPutStream(NULL);
    
  
    evhMSG_TYPE_KEY keyInit(msgTYPE_COMMAND,"MMINIT");
    evhOBJ_CALLBACK cbInit(this,(evhCB_METHOD)init);

    evhMSG_TYPE_KEY keyMMPA(msgTYPE_COMMAND,"MMPA");
    evhOBJ_CALLBACK cbMMPA(this,(evhCB_METHOD)movetoabs);

    evhMSG_TYPE_KEY keyMMPR(msgTYPE_COMMAND,"MMPR");
    evhOBJ_CALLBACK cbMMPR(this,(evhCB_METHOD)movetorel);

    evhMSG_TYPE_KEY keyMMOR(msgTYPE_COMMAND,"MMOR");
    evhOBJ_CALLBACK cbMMOR(this,(evhCB_METHOD)searchForHome);

     evhMSG_TYPE_KEY keyMMTP(msgTYPE_COMMAND,"MMTP");
    evhOBJ_CALLBACK cbMMTP(this,(evhCB_METHOD)readPosition);
    
    evhHandler->AddCallback(keyInit,cbInit);
    evhHandler->AddCallback(keyMMPA,cbMMPA);
    evhHandler->AddCallback(keyMMPR,cbMMPR);
    evhHandler->AddCallback(keyMMOR,cbMMOR);
    evhHandler->AddCallback(keyMMTP,cbMMTP);
 }


MotionControlerMM4000::~MotionControlerMM4000() {
 delete _mm4000;  
}


evhCB_COMPL_STAT MotionControlerMM4000::init(msgMESSAGE &msg, void *udate) {
    if (_mm4000==NULL) {
    //send back the reply
    msg.LastReply(ccsTRUE);
    msg.Buffer("ERROR : MM4000 not opened !");
    msg.SendReply();
    } 
    else {
    
    
    _mm4000->init();
    //send back the reply
    msg.LastReply(ccsTRUE);
    msg.Buffer("OK");
    msg.SendReply();
    
    
    }
    return evhCB_NO_DELETE;
    USE(udate);
}
evhCB_COMPL_STAT MotionControlerMM4000::movetoabs(msgMESSAGE &msg, void *udate) {
    
    int motor;
    float position;
    int errorCode;
    char errorString[256];

    if (_mm4000==NULL) {
    //send back the reply
    msg.LastReply(ccsTRUE);
    msg.Buffer("ERROR : MM4000 not opened !");
    } 
    else {
    
    
    if (sscanf(msg.Buffer(),"%d %g",&motor,&position)!=2)
	msg.Buffer("ERROR : illegal parameter !");
    else {
    if ((errorCode=_mm4000->movetoabs(motor,position))!=0)
	msg.Buffer(_mm4000->getErrorString(errorCode,errorString));
    else{
    //send back the reply
    msg.LastReply(ccsTRUE);
    msg.Buffer("OK");
    }
    }    
    }
    msg.SendReply();
    return evhCB_NO_DELETE;
    USE(udate);
}



evhCB_COMPL_STAT MotionControlerMM4000::movetorel(msgMESSAGE &msg, void *udate) {
    
    int motor;
    float position;
    int errorCode;
    char errorString[256];

    if (_mm4000==NULL) {
    //send back the reply
    msg.LastReply(ccsTRUE);
    msg.Buffer("ERROR : MM4000 not opened !");
    } 
    else {
    
    
    if (sscanf(msg.Buffer(),"%d %g",&motor,&position)!=2)
	msg.Buffer("ERROR : illegal parameter !");
    else {
    if ((errorCode=_mm4000->movetorel(motor,position))!=0)
	msg.Buffer(_mm4000->getErrorString(errorCode,errorString));
    else{
    //send back the reply
    msg.LastReply(ccsTRUE);
    msg.Buffer("OK");
    }
    }    
    }
    msg.SendReply();
    return evhCB_NO_DELETE;
    USE(udate);
}





evhCB_COMPL_STAT MotionControlerMM4000::searchForHome(msgMESSAGE &msg, void *udate) {
    
    int errorCode;
    char errorString[256];

    if (_mm4000==NULL) {
    //send back the reply
    msg.LastReply(ccsTRUE);
    msg.Buffer("ERROR : MM4000 not opened !");
    } 
    else {
    
    
    if ((errorCode=_mm4000->searchForHome())!=0)
	msg.Buffer(_mm4000->getErrorString(errorCode,errorString));
    else{
    //send back the reply
    msg.LastReply(ccsTRUE);
    msg.Buffer("OK");
    }
    }
    msg.SendReply();
    return evhCB_NO_DELETE;
    USE(udate);
}






evhCB_COMPL_STAT MotionControlerMM4000::readPosition(msgMESSAGE &msg, void *udate) {
    
    int motor;
    float position;
    char result[40];
    int errorCode;
    char errorString[256];

    if (_mm4000==NULL) {
    //send back the reply
    msg.LastReply(ccsTRUE);
    msg.Buffer("ERROR : MM4000 not opened !");
    } 
    else {
    
    
    if (sscanf(msg.Buffer(),"%d",&motor)!=1)
	msg.Buffer("ERROR : illegal parameter !");
    else {

    if ((errorCode=_mm4000->readPosition(motor,position))!=0)
	msg.Buffer(_mm4000->getErrorString(errorCode,errorString));
    else{
    //send back the reply
    sprintf(result,"OK:%g",position);
    msg.LastReply(ccsTRUE);
    msg.Buffer(result);
    }
    }    
    }
    msg.SendReply();
    return evhCB_NO_DELETE;
    USE(udate);
}
