// E.S.O.
// bgaillar  20/10/99  created 
//   DESCRIPTION
//   This unit is an interface between the standard VLT message
//   system and the ms257 monochromator. See the ms257 manual and 
//   the ms257drv.c file to have more information
//   The creation of this class reinit the monochromator (constructor)
//   the available messages are :
//   Message           Parameters
//   OINIT             None            Initialisation
//   OSWAV             wavelength      Set the monochromator wavelength in NM
//   OSPORT            port            Set the monochromator 2 port (B or C) 
//   OSBP              slitWidth       Set the width of slit 
//   OSFILT            filterNumber    Set the filer number
//   OSSHUT            shuterState     Set the state of the shutter
//                                     (open=1,close=2)



#include "fcdtTaskms257.h"


Oriel::Oriel(int debugMode) {
    
    int errorCode=0;
    char errorString[255]; 
    

    //initialisation
    ms257=new Ms257(&cout);
    if ((errorCode=ms257->init())!=0) {
    printf("ms257 init error ->  %s\n",ms257->getErrorString(errorCode,errorString));
    delete ms257;
    ms257=NULL;    
    //ccsExit();
    //exit(0);
    return;
    }
    if (debugMode==0)
	ms257->setOutPutStream(NULL);
    
  
    evhMSG_TYPE_KEY keyInit(msgTYPE_COMMAND,"OINIT");
    evhOBJ_CALLBACK cbInit(this,(evhCB_METHOD)init);
    evhMSG_TYPE_KEY keySetwav(msgTYPE_COMMAND,"OSWAV");
    evhOBJ_CALLBACK cbSetwav(this,(evhCB_METHOD)setWavelength);
    evhMSG_TYPE_KEY keySetport(msgTYPE_COMMAND,"OSPORT");
    evhOBJ_CALLBACK cbSetport(this,(evhCB_METHOD)setPortout);
    evhMSG_TYPE_KEY keySetband(msgTYPE_COMMAND,"OSBP");
    evhOBJ_CALLBACK cbSetband(this,(evhCB_METHOD)setBandpass);
    evhMSG_TYPE_KEY keySetfilter(msgTYPE_COMMAND,"OSFILT");
    evhOBJ_CALLBACK cbSetfilter(this,(evhCB_METHOD)setFilter);
    evhMSG_TYPE_KEY keySetshutter(msgTYPE_COMMAND,"OSSHUT");
    evhOBJ_CALLBACK cbSetshutter(this,(evhCB_METHOD)setShutter);

    evhHandler->AddCallback(keyInit,cbInit);
    evhHandler->AddCallback(keySetwav,cbSetwav);
    evhHandler->AddCallback(keySetport,cbSetport);
    evhHandler->AddCallback(keySetband,cbSetband);
    evhHandler->AddCallback(keySetfilter,cbSetfilter);
    evhHandler->AddCallback(keySetshutter,cbSetshutter);
 }


Oriel::~Oriel() {
 delete ms257;  
}


evhCB_COMPL_STAT Oriel::init(msgMESSAGE &msg, void *udate) {
    if (ms257==NULL) {
    //send back the reply
    msg.LastReply(ccsTRUE);
    msg.Buffer("ERROR : ms257 not opened !");
    msg.SendReply();
    } 
    else {
    
    
    ms257->init();
    //send back the reply
    msg.LastReply(ccsTRUE);
    msg.Buffer("OK");
    msg.SendReply();
    
    
    }
    return evhCB_NO_DELETE;
    USE(udate);
}

evhCB_COMPL_STAT Oriel::setWavelength(msgMESSAGE &msg, void *udate) {
    float waveLength;
    int errorCode=0;
    char errorString[255];
    
    msg.LastReply(ccsTRUE);
    if (ms257==NULL) 
	msg.Buffer("ERROR : ms257 not opened !");
    else
	if (sscanf(msg.Buffer(),"%f",&waveLength)!=1)
	    msg.Buffer("ERROR : illegal parameter !");
	else
	    if ((errorCode=ms257->setWavelength(waveLength))!=0)
		msg.Buffer(ms257->getErrorString(errorCode,errorString));
	    else
		msg.Buffer("OK");    
    
    msg.SendReply();
    
    return evhCB_NO_DELETE;
    USE(udate);
    }



evhCB_COMPL_STAT Oriel::setPortout(msgMESSAGE &msg, void *udate) {
    
    int errorCode=0;
    char errorString[255];
    
    
    msg.LastReply(ccsTRUE);
    if (ms257==NULL) 
	msg.Buffer("ERROR : ms257 not opened !");
    else 
	if (strlen(msg.Buffer())<1)
	    msg.Buffer("ERROR : The parameter must be one char.");
	else
	    if ((errorCode=ms257->setPortout(msg.Buffer()[0]))!=0)
		msg.Buffer(ms257->getErrorString(errorCode,errorString));
	    else
		msg.Buffer("OK");
    
    msg.SendReply();
    
    return evhCB_NO_DELETE;
    USE(udate);
}


evhCB_COMPL_STAT Oriel::setBandpass(msgMESSAGE &msg, void *udate) {
    float bandpass;
    int errorCode=0;
    char errorString[255];
    
    msg.LastReply(ccsTRUE);
    if (ms257==NULL)
	msg.Buffer("ERROR : ms257 not opened !");
    else 
	if (sscanf(msg.Buffer(),"%f",&bandpass)!=1)
	    msg.Buffer("ERROR : illegal parameter !");
	else	    
	    if ((errorCode=ms257->setBandpass(bandpass))!=0)
		msg.Buffer(ms257->getErrorString(errorCode,errorString));
	    else
		msg.Buffer("OK");	
    msg.SendReply();
    return evhCB_NO_DELETE;
    USE(udate);
}


evhCB_COMPL_STAT Oriel::setFilter(msgMESSAGE &msg, void *udate) {
int errorCode=0;
char errorString[255];

int filter;

msg.LastReply(ccsTRUE);
if (ms257==NULL)
    msg.Buffer("ERROR : ms257 not opened !");
else
    if (sscanf(msg.Buffer(),"%d",&filter)!=1)
	msg.Buffer("ERROR : illegal parameter !");
    else	
	if ((errorCode=ms257->setFilter(filter))!=0)
	    msg.Buffer(ms257->getErrorString(errorCode,errorString));  
	else
	    msg.Buffer("OK");

msg.SendReply();

return evhCB_NO_DELETE;
USE(udate);
}
	



evhCB_COMPL_STAT Oriel::setShutter(msgMESSAGE &msg, void *udate) {
int errorCode=0;
char errorString[255];

int shutterState;

msg.LastReply(ccsTRUE);
if (ms257==NULL)
    msg.Buffer("ERROR : ms257 not opened !");
else
    if (sscanf(msg.Buffer(),"%d",&shutterState)!=1)
	msg.Buffer("ERROR : illegal parameter !");
    else	
	if ((errorCode=ms257->setShutter(shutterState))!=0)
	    msg.Buffer(ms257->getErrorString(errorCode,errorString));  
	else
	    msg.Buffer("OK");

msg.SendReply();

return evhCB_NO_DELETE;
USE(udate);
}
	
