// E.S.O.
// bgaillar  20/10/99  created 
//
//
//KE6514 driver
//purpose : this unit is an high level interface to access to the ammeter
//ke6514 on the CCD test bench
//At first, initialize the device by calling the init function 
//
// E.S.O.
// bgaillar  20/10/99  created 
//
//
// mesureSerie
// 
// setOutPutStream     Set the ouput standard message stream.NULL if
//                     no message. 

#include <stdio.h>
#include "ke6514drv.h"
#include "ke6514_err.h"
#include <stdlib.h>


//ke6514 adress beetween 0 and 30    
#define GPIBAddress 14

//
#define ERRMSQ 0x8000


Ke6514::Ke6514() {
    int interI;

    device=-1;

    // It opens the amp1
    if (!((interI=ibfind("/dev/amp2")) & ERRMSQ)) 
	device=interI;
}

Ke6514::Ke6514(ostream * outputS) {
    int interI;

    device=-1;
    this->outputS=outputS;

    // It opens the amp1
    if (outputS!=NULL) 
	(*outputS) <<"Opening /dev/amp2\n";
    if (!((interI=ibfind("/dev/amp2")) & ERRMSQ)) 
	device=interI;
}

Ke6514::~Ke6514() {
    if (device!=-1) {
    // ibloc places device in local    
    ibloc(device);
    ibonl(device,0);
    }
}

// Function: SetOutPutStream
// Purpose:  Set the ouput standard message stream.NULL if
//           no message. 
void Ke6514::setOutPutStream(ostream * outputS) {
    this->outputS=outputS;
}



// Function: Read data
// Purpose:  This function reads a buffer of data from the GPIB interface
//           using the 488.2 library function ibrd.
//           The return value is equal to the global error variable
int Ke6514::readBuffer(char *cmd,int cnt) {    
    int errorCode=0; 
    if (ibrd(device,cmd,(long)cnt) & ERRMSQ)
        errorCode=101;
    return errorCode;
}


// Function: Write data
// Purpose:  This function writes a buffer of data to the GPIB interface
//           using the 488.2 library function ibwrt.
//           The return value is equal to the global error variable

int Ke6514::writeBuffer (char *cmd, int cnt) {
    int errorCode=0;

    if (ibwrt(device,cmd,(long)cnt) & ERRMSQ)
        return errorCode=102;
    
    // if check(0X20)== 0 the 5th bit has been set. An error has occured.
    // The error_ident function performs a serial poll and returns the
    // error string coming from the device.
   

    return errorCode;
}





// Function: getString
// Purpose:  This function get an error string
/*void getString(int num,char separator,char * str,char * strBack) {
     int i=0;int j=0;
    strBack[0]=0;
    for (;((i<num-1) && (str[j]!=0));i++) {
    for (;((str[j]!=0) && (str[j++]!=separator)););
    }
    if (str[j]!=0) {
    for (i=0;((str[j]!=0) && (str[j]!=separator));strBack[i++]=str[j++]);
    strBack[j+1]=0;
    } 
}*/






// Function: Initialize
// Purpose:  This function opens the instrument, queries the instrument
//           for its ID, and initializes the instrument to a known state.
int Ke6514::init() {
    int nbcmd;
    char cmd[256];
    int errorCode=0;
    int stb;
    

    
    
    if (device==-1)
	return 1;
    
    
    // check if the remote status is enabled. If check(0X20)== 0 the 5th bit has been set.
    //(keythley Man. pag 4-22. In this case, REN is set sending the Listen address.
    // The error_ident function performs a serial poll and returns the
    // error string coming from the device.
    
    if (outputS!=NULL)
	(*outputS) << "init ke6514...\n";
    

    if (ibsre(0,GPIBAddress) & ERRMSQ) {
    ibcmd(device,"@?'",3); 
    }    
    else
	errorCode=0;
    if (outputS!=NULL)
	(*outputS) << "reset the ke6514\n";
    // clears the device
    if (ibclr(device) & ERRMSQ)  {
    return 2;
    }    	

    //ID query
    sprintf(cmd,"%s\n","*IDN?");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
    	return errorCode;
    if ((errorCode=readBuffer(cmd,256))!=0)
    	return errorCode;
    if (outputS!=NULL)
	(*outputS) << "ID:" << cmd << "\n";


    //Clear the error buffer
    sprintf(cmd,"%s\n","SYST:CLE");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode; 

   
    //Clear everything
    sprintf(cmd,"%s\n","*RST");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;
    
    sprintf(cmd,"%s\n","FORM REAL");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;


    sprintf(cmd,"%s\n","FORM:ELEM READ");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;

    sprintf(cmd,"%s\n","SYST:AZER ON");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;

    sprintf(cmd,"%s\n","SYST:ZCH OFF");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;

    sprintf(cmd,"%s\n","SYST:ZCOR OFF");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;

    sprintf(cmd,"%s\n","CURR:RANG:AUTO ON");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;

    
    sprintf(cmd,"%s\n","FUNC 'CURR'");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;

    sprintf(cmd,"%s\n","TRIG:DEL:AUTO ON");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;

    
    sprintf(cmd,"%s\n","CURR:NPLC 2");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;

    sprintf(cmd,"%s\n","*STB?");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;
    if ((errorCode=readBuffer(cmd,200))!=0)
	return errorCode;
    sscanf(cmd,"%d",&stb);
  
    if ((stb & 4)==4) {
    sprintf(cmd,"%s\n","SYST:ERR:CODE?");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;
    if ((errorCode=readBuffer(cmd,200))!=0)
	return errorCode;
    if (outputS!=NULL)
	(*outputS) << "EROR ! (code=" << cmd << "\n";
    errorCode=2000+stb;//SQR error
    return errorCode;
    }
      
    
    if (outputS!=NULL)
	(*outputS) << "ke6514 init ended.\n";
	    
    return errorCode;
}




// Function: mesureSerie
// Purpose:  This function reads multiple data entries
/*int Ke6514::mesureSerie(int NumberOfPoints,float *DataArray) {
    int nbcmd;
    char cmd[256];
    int errorCode=0;
    char * buffer;
    
    sprintf(cmd,"%s\n","DISP:ENAB OFF");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;
    
    sprintf(cmd,"%s\n","ARM:SOUR IMM");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;
    
    sprintf(cmd,"%s\n","ARM:COUNT 1");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;
    
    sprintf(cmd,"%s\n","TRIG:SOUR IMM");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;
    
    sprintf(cmd,"%s %d\n","TRIG:COUN",NumberOfPoints);
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;
    
    sprintf(cmd,"%s\n","INIT");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode; 
    

    

    buffer=(char *)malloc(NumberOfPoints*4+3);
    
    sprintf(cmd,"%s\n","READ?");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;
    
   

    if ((errorCode=readBuffer(buffer,NumberOfPoints*4+3))!=0)
	return errorCode;

    memcpy(DataArray,buffer+2,NumberOfPoints*4);

    free(buffer);

    sprintf(cmd,"%s\n","DISP:ENAB ON");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;
    

    return 0;
}
*/




// Function: mesureSerie
// Purpose:  This function reads multiple data entries
int Ke6514::mesureSerie(int NumberOfPoints,float *DataArray) {
    int nbcmd;
    char cmd[20000];
    int errorCode=0;
    char * buffer;
    short int poll;
    int interI;
    int stb;
    short int result;

    int test;


    //Clear the error buffer
    sprintf(cmd,"%s\n","SYST:CLE");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode; 



    
    sprintf(cmd,"%s\n","*STB?");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;
    if ((errorCode=readBuffer(cmd,200))!=0)
	return errorCode;
    printf("STB1 %s\n",cmd);
   


    //Reset status subsystem
    sprintf(cmd,"%s\n","STAT:PRES;*CLS");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;

    

    
    sprintf(cmd,"%s\n","*STB?");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;
    if ((errorCode=readBuffer(cmd,200))!=0)
	return errorCode;
    printf("STB3 %s\n",cmd);



    //enable BFL (Buffer full)
    sprintf(cmd,"%s\n","STAT:MEAS:ENAB 512");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;
    

    sprintf(cmd,"%s\n","*STB?");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;
    if ((errorCode=readBuffer(cmd,200))!=0)
	return errorCode;
    printf("STB5 %s\n",cmd);
    


    //Enable MSB
    sprintf(cmd,"%s\n","*SRE 1");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;


    //Stop storing reading (otherwise you can`t change ther buffer size)
    sprintf(cmd,"%s\n","TRAC:FEED:CONT NEV");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode; 


    //Trigger count number 
    sprintf(cmd,"%s %d\n","TRIG:COUN",NumberOfPoints);
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;
    
    sprintf(cmd,"%s\n","*STB?");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;
    if ((errorCode=readBuffer(cmd,200))!=0)
	return errorCode;
    printf("STB6 %s\n",cmd);


    //Buffer size number
    sprintf(cmd,"%s %d\n","TRAC:POIN",NumberOfPoints);
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode; 

    sprintf(cmd,"%s\n","*STB?");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;
    if ((errorCode=readBuffer(cmd,200))!=0)
	return errorCode;
    printf("STB7 %s\n",cmd);


    //Enable buffer reading
    sprintf(cmd,"%s\n","TRAC:FEED SENS1;FEED:CONT NEXT");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode; 


    
    sprintf(cmd,"%s\n","*STB?");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;
    if ((errorCode=readBuffer(cmd,200))!=0)
	return errorCode;
    printf("STB8 %s\n",cmd);
    sscanf(cmd,"%d",&stb);
    printf("STB8=%x",stb);
    

    if ((stb & 4)==4) {
    sprintf(cmd,"%s\n","SYST:ERR:CODE?");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;
    if ((errorCode=readBuffer(cmd,200))!=0)
	return errorCode;
    printf("Stb : %x Error code : %s\n",stb,cmd);
    errorCode=2000+stb;//SQR error
    return errorCode;
    }
    

    //Start
    sprintf(cmd,"%s\n","STAT:MEAS?");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;
    if ((errorCode=readBuffer(cmd,200))!=0)	 
	return errorCode;
    printf("%s\n",cmd);
    

 
    //Start
    sprintf(cmd,"%s\n","INIT");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;
    
    
    test=0;
    for(poll=0;(poll & 64)==0;){
    printf("wait...\n");

    //Check the SRQ line (common with every GPIB device)
    WaitSRQ(0,&result);

    printf("poll\n");

    //Check the Buffer full flag 
    if ((ibrsp(device,(char *)(&poll))) & ERRMSQ)
    	return 1;    
    interI=poll; 
    printf("POLL %x\n",interI);
    if ((poll & 64)==64)
	printf("popol\n");

    test++;
    interI=interI >> 8;
    poll=poll >> 8;
    printf("POLL  %x  %x \n",(interI & 64),interI);
    }
    

    printf("Ok... %d\n",test);
    
    
    buffer=(char *)malloc(NumberOfPoints*4+3);



    //Read the data (FLOAT format)
    sprintf(cmd,"%s\n","TRAC:DATA?");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)	 
	return errorCode;
    
   
    if ((errorCode=readBuffer(buffer,NumberOfPoints*4+3))!=0)
	return errorCode;

    //printf("%f\n",cmd);

    memcpy(DataArray,buffer+2,NumberOfPoints*4);

    free(buffer);


    
    return 0;
}












// Function: Send error messages corresponding to the error code
char * Ke6514::getErrorString(int errorCode,char * errorString) {
    if (errorCode>1000) {
    sprintf(errorString,"%s (%d)",defke6512,errorCode);
    }
    else {
    switch (errorCode) {
    case 101:sprintf(errorString,"%s (%d)",E101,errorCode);break;
    case 102:sprintf(errorString,"%s (%d)",E102,errorCode);break;
    default:sprintf(errorString,"%s (%d)",def,errorCode);
    }
    
    }
    return errorString;
    
}



/*
// Function: Checks errors from the device
// Purpose:  This function identifies an error generated by the device
//           It is called by the ke486_write_data function whenever a
//           serial poll detects an error occurence (5th bit set).
//           It returns a string indicating the type of error.
//			 All error codes are described in Ke 486 User manual page 4-34
int Ke486::errorIdent() {
    char string[14];
    char cmd[256];
    int errorCode=0;
    int i;

    // Query the error string from the device
     
    if (ibwrt(device,"U1X",3)& ERRMSQ) 
        errorCode=102;
    
    if (ibrd (device,cmd,16) & ERRMSQ)
        errorCode=101;

    if (scanf(&(cmd[3]),"%s",string)==0)
	return 40;

    // Build the error code
    for (i=0;(i<13);i++)
	if (string[i]=='1')
	    return 300+i;
	    
    
    return 0;
}*/








