// E.S.O.
// bgaillar  20/10/99  created 
//
//
// mm4000 driver
//purpose : this unit is an high level interface to access to the Newport
// MM4000 motion controler 
//At first, initialize the device by calling the init function 
//
// init                  Initialize the monochromator
//
// setOutPutStream       Set the ouput standard message stream.NULL if
//                       no message. 

#include "mm4000drv.h"
#include "mm4000_err.h"
#include <stdio.h>

#define ERRMSQ 0x8000


// Purpose:  This function opens the instrument, queries the instrument
//           for its ID, and initializes the instrument to a known state.
mm4000::mm4000() {
    int interI;
    
    outputS=NULL;
    
    // It opens the motion controler 
    if (!((interI=ibfind("/dev/MM4000")) & ERRMSQ)) 
	device=interI;
   
}

mm4000::mm4000(ostream * outputS) {
    int interI;
    
    this->outputS=outputS;
    
    if (outputS!=NULL)
	(*outputS) << "Opening /dev/MM4000\n";
    if (!((interI=ibfind("/dev/MM4000")) & ERRMSQ)) 
	device=interI;
}


// Function: Close
mm4000::~mm4000() {
    if (device!=-1)
	ibonl(device,0);
}

// Purpose:  This function write data to the motion controler
//           using the 488.2 library function ibrd.
int mm4000::writeBuffer(char *string,int cnt) {
    if (device==-1) 
	return 101;

    if (ibwrt(device,string,cnt) & ERRMSQ)
	return 110;
    return 0;    
}


// Function: Read buffer
// Purpose:  This function reads a buffer of data from the motion device
//           using the 488.2 library function ibrd.
int mm4000::readBuffer(char *cmd,int cnt) {    
    int errorCode=0; 
    if (ibrd(device,cmd,(long)cnt) & ERRMSQ)
        errorCode=120;
    return errorCode;
}

int mm4000::init() {
    char cmd[200];
    int errorCode;
    
    if (outputS!=NULL)
	(*outputS) << "init mm4000...\n";
    
    
    if (device==-1) 
	return 101;
    
    if (outputS!=NULL)
	(*outputS) << "reset mm4000\n";

    if (ibclr(device) & ERRMSQ)
    	return 102;



    if ((errorCode=writeBuffer("VE\r",3))!=0)
	return errorCode;

    sleep(2);
    
    if ((errorCode=readBuffer(cmd,50))!=0)
	return errorCode;

    if (outputS!=NULL)
	(*outputS) << "MM4000 : ID= " << cmd << "\n";




    if (outputS!=NULL)
	(*outputS) << "MM4000 : Setting motor ON\n";
    
    if ((errorCode=writeBuffer("MO\r",4))!=0)
	return errorCode;
 

    

    return 0;
  
}

int mm4000::movetoabs(int motor,float position) {
    char cmd[200];
    char motorChr[40];
    char positionChr[40];
    
    int nbcmd;
    int errorCode;

    sprintf(motorChr,"%d",motor);
    sprintf(positionChr,"%g",position);

    sprintf(cmd,"%sPA%s\r",motorChr,positionChr);
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)
	return errorCode;
    
    return 0;

}

int mm4000::movetorel(int motor,float position) {
    char cmd[200];
    char motorChr[40];
    char positionChr[40];
    
    int nbcmd;
    int errorCode;

    sprintf(motorChr,"%d",motor);
    sprintf(positionChr,"%g",position);

    sprintf(cmd,"%sPR%s\r",motorChr,positionChr);
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)
	return errorCode;
    
    return 0;

}


int mm4000::searchForHome() {
    char cmd[200];    
    int nbcmd;
    int errorCode;

    sprintf(cmd,"OR\r");
    nbcmd=strlen(cmd);
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)
	return errorCode;

    return 0;
}




int mm4000::readPosition(int motor,float & position) {
    char cmd[200];
    
    int nbcmd;
    int errorCode;

    sprintf(cmd,"%dTP\r",motor);
    nbcmd=strlen(cmd);

    
    if ((errorCode=writeBuffer(cmd,nbcmd))!=0)
	return errorCode;

    sleep(1);

    if ((errorCode=readBuffer(cmd,50))!=0)
	return errorCode;

     if (strlen(cmd)<3) 
	return 200;  

     sscanf(&(cmd[3]),"%g",&position);
     
    
    return 0;

}




// Function: SetOutPutStream
// Purpose:  Set the ouput standard message stream.NULL if
//           no message. 
void mm4000::setOutPutStream(ostream * outputS) {
    this->outputS=outputS;
}


// Function: Send error messages corresponding to the error code
char * mm4000::getErrorString(int errorCode,char * errorString) {
switch (errorCode) {
    case 101: sprintf(errorString,"%s",E101); break;
    case 102: sprintf(errorString,"%s",E102); break;
    case 110: sprintf(errorString,"%s",E110); break;
    case 200: sprintf(errorString,"%s",E200); break;
    default: sprintf(errorString,"%s",def);
    }   
    return errorString;
} 

