/*----------------------------------------------*/
/* Error Module for ms257 double monochromator  */                                                
/* LabWindows 2.0 Instrument Driver             */                               
/* Authors: 	  Paola Amico and Torsten Boehm */
/* Created:       March 1998                    */
/* Tested:		  March 1998					*/
/* Related files: ms257.h, ms257.doc, ms257.fp  */ 
/*                ms257_err.h, ms257.c			*/
/*----------------------------------------------*/


/* This module assigns an error message to the error code */
/* provided by the main program                           */

#include <stdio.h>
#include <ms257_err.h>


int ms257_error_id(int ms257_err, char *errormessage)

{
	switch(ms257_err){
	
		case 101: sprintf("%s>%s",errormessage,E101); break;
		case 201: sprintf("%s>%s",errormessage,E201); break;
		case 102: sprintf("%s>%s",errormessage,E102); break;
		case 202: sprintf("%s>%s",errormessage,E202); break;
		case 120: sprintf("%s>%s",errormessage,E120); break;
		case 1111: sprintf("%s>%s",errormessage,E1111); break;
		case 2111: sprintf("%s>%s",errormessage,E2111); break;
		case 311: sprintf("%s>%s",errormessage,E311); break;
		case 3: sprintf("%s>%s",errormessage,E3); break;
		case 4: sprintf("%s>%s",errormessage,E4); break;
		case 13: sprintf("%s>%s",errormessage,E13); break;
		case 16: sprintf("%s>%s",errormessage,E16); break;
		case 17: sprintf("%s>%s",errormessage,E15); break;
		case 27: sprintf("%s>%s",errormessage,E27); break;
		case 12: sprintf("%s>%s",errormessage,E12); break;
		case 22: sprintf("%s>%s",errormessage,E22); break;
		case 99: sprintf("%s>%s",errormessage,E99); break;
		case 333: sprintf("%s>%s",errormessage,E333); break;
		case 112: sprintf("%s>%s",errormessage,E112); break;
		case 212: sprintf("%s>%s",errormessage,E212); break;
		case 312: sprintf("%s>%s",errormessage,E312); break;
		case 14: sprintf("%s>%s",errormessage,E14); break;
		case 15: sprintf("%s>%s",errormessage,E15); break;
		default: sprintf("%s>%s",errormessage,def);
				 return -1;         	
	}
	   return 0;
}




