/*****************************************************************************
* Airy disk with central obstruction, argument expected in radians
*****************************************************************************/

#include <math.h>
#include <gsl/gsl_sf_bessel.h>


double airy_disk_obs(double w, double q, double x) {

  double   y, res;

  
  y = sin(x) / w;

  if (y == 0.0)
    return 1.0;

  res = 2.0 * (gsl_sf_bessel_J1(y) - q * gsl_sf_bessel_J1(q * y)) / y 
    / (1 - q*q);
  return res * res;
}
