/******************************************************************************
* Convert an angle with the x axis from image/logical coordinates to physical
******************************************************************************/

#include <math.h>
#include "const.h"
#include "geom.h"
#include "img.h"


double ang_img2phys(image *img, double alphai) {

  double  alphap;
  point   p1, p2;
  int     fcmp(float, float, int);
  void    img2phys(image *, double, double, double *, double *);


  img2phys(img, 0.0, 0.0, &(p1.x), &(p1.y));
  img2phys(img, cos(alphai * RPDEG), sin(alphai * RPDEG), &(p2.x), &(p2.y));

  if (fcmp(p2.x, p1.x, 1)) {
    if (p2.y > p1.y)
      return 0.0;
    else
      return 180.0;
  }

  alphap = atan((p2.y - p1.y) / (p2.x - p1.x)) / RPDEG;

  if (p2.x < p1.x) {
    if (p2.y > p1.y)
      alphap += 180.0;
    else
      alphap -= 180.0;
  }

  return alphap;
}
