/******************************************************************************
* Calculate surface brightness in elliptical annuli;
* each ellipse is assumed to have the same centre, ellipticity and orientation;
* the array major axes are assumed to be in ascending order
******************************************************************************/

#include <stdio.h>
#include <math.h>
#include "const.h"
#include "img.h"
#include "geom.h"


void apsbean(image *img, ellipse apert[], int nap, double bg, double flux[]) {

  int          i;
  void         apfluxe(image *, ellipse *, int, double, double *);


  /* Calculate the flux in each ellipse */
  apfluxe(img, apert, nap, bg, flux);

  /* Subtract the flux of inner ellipse from outer one */
  for (i = nap - 1; i > 0; i--)
    flux[i] -= flux[i-1];

  /* Divide by area assuming that all ellipses were completely on image */
  flux[0] /= PI * apert[0].maj * apert[0].min;
  for (i = 1; i < nap; i++)
    flux[i] /= PI * (apert[i].maj * apert[i].min - 
		     apert[i-1].maj * apert[i-1].min);
  
  return;
}
