/******************************************************************************
* Calculate surface brightness in an elliptical annulus
******************************************************************************/

#include <stdio.h>
#include <math.h>
#include "img.h"
#include "geom.h"


double apsbean1(image *img, eannulus apert, double bg) {

  double       flux[2];
  ellipse      el[2];
  void         ean2el(eannulus, ellipse *, ellipse *),
               apsbean(image *, ellipse *, int, double, double *);


  /* Convert the annulus to two ellipses */
  ean2el(apert, el, el+1);

  /* Calculate the flux in each ellipse */
  apsbean(img, el, 2, bg, flux);

  return flux[1];
}
