/****************************************************************************
* Routine to bin data
* x[] contains the lower edges of the bins and is of size nbins+1
* data outside of [x[0],x[nbins]) is not included
****************************************************************************/


void bin(float data[], int ndata, float bin[], float x[], int nbins) {

  int i, j;


  for (i = 0; i < ndata; i++) {
    if (data[i] < x[0] || data[i] >= x[nbins])
      continue;
    j = 0;
    while (data[i] >= x[j]) {
      j++;
      if (j == nbins)
	break;
    }
    bin[j-1]++;
  }
}
