/*****************************************************************************
* Constants
*****************************************************************************/

#ifndef J_CONST_H

#define J_CONST_H

/* Numbers */
#define  PI      M_PI             /* Pi */
#define  PI2     M_PI_2           /* pi / 2 */
#define  SQRTPI  1.772453850905516 /* Square root of pi */
#define  RPDEG   0.017453292519943 /* Radians per degree: pi / 180 */
#define  RPMAS   4.848136811095e-9 /* Radians per mas */
#define  SQRT2   M_SQRT2          /* Square root of 2 */
#define  LN10    M_LN10           /* Natural logarithm of 10 */
#define  LN2     M_LN2            /* Natural logarithm of 2 */
#define  LOGE    M_LOG10E         /* log_10 e */
#define  L2PI    0.798179868358115 /* log_10 2*pi */
#define  ZETA3   1.2020564        /* Euler's zeta(3) */
#define  FWHMSIG 2.354820045      /* FWHM / sigma = 2 * sqrt(2 ln 2) */

/* Physics */
#define  C       299792.458       /* Velocity of light in km/s */
#define  M_N     1.6749286e-27    /* Neutron mass in kg */
#define  M_P     1.6726231e-27    /* Proton mass in kg */
#define  U       1.6605402e-27    /* Atomic mass unit (= m(12C) / 12) in kg */
#define  M_EL    9.1093897e-31    /* Electron mass in kg */
#define  Q_EL    1.60217733e-19   /* Electron charge in C */
#define  EPS_0   8.854188e-12     /* Permittivity of free space in C^2/Nm^2 */
#define  MU_0    12.56637e-7      /* Permeability of free space in N/A^2 */
#define  K_B     1.380658e-23     /* Boltzmann's constant in J/K */
#define  S_B     5.67051e-8       /* Stefan-Boltzmann constant in W/m^2/K^4 */
#define  N_A     6.0221367e23     /* Avogadro's constant in 1/mol */
#define  P_H     6.6260755e-34    /* Planck's constant in Js */
#define  G       6.67259e-11      /* Gravitational constant in m^3/kg/s^2 */
#define  FALPHA  7.29735308e-3    /* Fine structure constant */
#define  A_0     0.529177249e-10  /* Radius of first Boh orbit in m */

/* Cosmology */
#define  T_CMB   2.725            /* Temperature of the CMB in K */
#define  D_H_0   70.0             /* Default Hubble constant in km/s/Mpc */
#define  D_O_M   0.3              /* Default value of O_M */
#define  D_O_R   0.0              /* Default value of O_R */
#define  D_O_L   0.7              /* Default value of O_L */
#define  D_W_L   (-1.0)           /* Default value of w_L */
#define  O_CMB   (32.0 * PI * G * S_B * pow(T_CMB, 4.0) / (3.0 * pow(H_0 / (1.0e3 * PC), 2.0) * pow(C * 1.0e3, 3.0)))
                                  /* O_CMB */
#define  O_NU    (3.0 * 7.0 / 8.0 * pow(4.0 / 11.0, 4.0 / 3.0) * O_CMB)
                                  /* O_neutrino */

/* Astronomy */
#define  PC      3.0856776e16     /* Parsec in m */
#define  AU      1.4959787066e11  /* Astronomical unit in m */
#define  LY      9.460730472e15   /* Lightyear in m */
#define  M_S     1.9891e30        /* Solar mass in kg */
#define  L_S     3.845e26         /* Solar luminosity in W */
#define  R_S     6.95508e8        /* Solar equatorial radius in m */
#define  T_S     5777.0           /* Solar effective temperature in K */
#define  M_EA    5.9742e24        /* Earth mass in kg */
#define  R_EA    6.378136e6       /* Earth mean equatorial radius in m */

/* Some atomic data */
#define  LY_A    1215.6701        /* Wavelength of Lyman alpha in Angstrom */
#define  LY_B    1025.7223        /* Wavelength of Lyman beta in Angstrom */
#define  HI_IP   13.598292        /* HI ionisiation potential in eV */
#define  LL      911.763345       /* Wavelength of Lyman limit in Angstrom */
#define  HICS    6.304319e-22     /* Hydrogen ionization cross-section at LL */
#define  CIV     1548.195         /* Wavelength of CIV in Angstrom */
#define  SIIV    1393.755         /* Wavelength of SiIV in Angstrom */

#endif
