/******************************************************************************
* Draw an sline
******************************************************************************/

#include <math.h>
#include <cpgplot.h>
#include "geom.h"


void cpgdsline(sline sl) {

  float   xmin, xmax, ymin, ymax, y;


  cpgqwin(&xmin, &xmax, &ymin, &ymax);
  y = sl.c + sl.m * xmin;
  if (y < ymin)
    cpgmove((float)((ymin - sl.c) / sl.m), ymin);
  else if (y > ymax)
    cpgmove((float)((ymax - sl.c) / sl.m), ymax);
  else
    cpgmove(xmin, (float)(sl.c + sl.m * xmin));
  
  y = sl.c + sl.m * xmax;
  if (y < ymin)
    cpgdraw((float)((ymin - sl.c) / sl.m), ymin);
  else if (y > ymax)
    cpgdraw((float)((ymax - sl.c) / sl.m), ymax);
  else
    cpgdraw(xmax, (float)(sl.c + sl.m * xmax));

  return;
}
