/*****************************************************************************
* Get a string from stdin via a cpgplot interface, character by character,
* with file name completion, history (using Ctrl-p and Ctrl-n instead of 
* up and down arrow keys) and paste (Ctrl-v); a maximum of size characters
* are read, no trailing newline; this routine is the equivalent to getscbc();
* the string pre will precede the input
*****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <cpgplot.h>

#define N_HIST   11   /* Number of lines kept in history */
#define L_WORD   500  /* Maximum length of lines kept in history */
#define FGCOL    15   /* Text foreground colour */
#define BGCOL    7    /* Text background colour */


void cpggets(char *pre, char *s, int size) {

  int               i, npre;
  static int        ihist=0, nhist=0;
  char              com, *show, *buf;
  float             ch, x, y, xch, ych;
  static char       hist[N_HIST][L_WORD];
  int               getselection(char **, int);
  void              errormsg(char *, ...), fcompl(char *, int);


  /* Setup */
  cpgstbg(BGCOL);
  cpgqch(&ch);
  cpgsch(1.2 * ch);
  cpgqcs(4, &xch, &ych);
  xch *= 0.5;
  ych *= 0.3;

  npre = strlen(pre);
  if ((show = (char *)calloc(npre+size+1, sizeof(char))) == NULL)
    errormsg("cpggets(): Couldn't allocate memory!");
  sprintf(show, "%s !", pre);
  cpgsci(BGCOL);
  cpgmtxt("B", 1.0, 0.0, 0.0, show);
  cpgsci(FGCOL);
  cpgqpos(&x, &y);
  x += xch; 
  y += ych;
  show[npre+1] = '\0';
  cpgmtxt("B", 1.0, 0.0, 0.0, show);

  i = npre + 1;
  while (i < npre + size + 1) {
    /* Get the next character */
    cpgcurs(&x, &y, &com);

    if (com == '\n' || com == '\r' || com+64 == 'D') {
      /* End of input */
      break;

    } else if (com == 127 || com == '\b') {
      /* Backspace */
      if (i > npre + 1) {
	cpgsci(BGCOL);
	cpgmtxt("B", 1.0, 0.0, 0.0, show);
	cpgsci(FGCOL);
	show[--i] = '\0';
      }

    } else if (com == '\t') {
      /* File name completion */
      show[i] = '\0';
      buf = ((buf = strrchr(show, ' ')) != NULL) ? buf+1 : show;
      fcompl(buf, 0);
      i = strlen(show);

    } else if (com+64 == 'P') {
      /* History */
      if (ihist == 0)
	fprintf(stderr, "\a");
      else {
	show[i] = '\0';
	cpgsci(BGCOL);
	cpgmtxt("B", 1.0, 0.0, 0.0, show);
	cpgsci(FGCOL);
	if (ihist == nhist)
	  strcpy(hist[ihist], show + npre + 1);
	sprintf(show, "%s %s", pre, hist[--ihist]);
	i = strlen(show);
      }
      
    } else if (com+64 == 'N') {
      /* History */
      if (ihist == nhist)
	fprintf(stderr, "\a");
      else {
	show[i] = '\0';
	cpgsci(BGCOL);
	cpgmtxt("B", 1.0, 0.0, 0.0, show);
	cpgsci(FGCOL);
	sprintf(show, "%s %s", pre, hist[++ihist]);
	i = strlen(show);
      }

    } else if (com+64 == 'V') {
      /* Paste selection */
      getselection(&buf, 0);
      show[i] = '\0';
      strcat(show, buf);
      i = strlen(show);
      
    } else if (com < 32) {
      /* Other control characters */
      continue;

    } else {
      /* Regular character */
      show[i] = com;
      show[++i] = '\0';
    }

    if (show[i-1] == ' ') {
      /* Some special trickery to display a trailing space */
      show[i] = '!';
      show[i+1] = '\0';
      cpgsci(BGCOL);
      cpgmtxt("B", 1.0, 0.0, 0.0, show);
      cpgsci(FGCOL);
      show[i] = '\0';
    }

    cpgmtxt("B", 1.0, 0.0, 0.0, show);
    cpgqpos(&x, &y);
    x += xch; 
    y += ych;
  }

  strcpy(s, show + npre + 1);

  /* Push on history stack */
  strcpy(hist[nhist], s);
  if (nhist != N_HIST-1)
    nhist++;
  else {
    for (i = 1; i < N_HIST; i++)
      strcpy(hist[i-1], hist[i]);
  }
  ihist = nhist;

  /* Clean up */
  cpgsci(1);
  cpgstbg(-1);
  cpgsch(ch);
  free(show);

  return;
}
