/*****************************************************************************
* Get input from stdin via a cpgplot interface.
* Only integers, floats, doubles, characters and strings are allowed.
* Values stored in the arguments will be offered as defaults unless
* the first character of the format string is not a '%'.
*****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <cpgplot.h>

#define L_WORD  500   /* Maximum string length that can be handled */


void cpginput(char *query, char *fmt, ...) {

  int         *ip, i, flag;
  float       *fp;
  double      *dp;
  char        *p, *cp, deffmt[L_WORD], *pre, answer[L_WORD], *pans;
  va_list     ap;
  void        errormsg(char *, ...), cpggets(char *, char *, int);

  
  /* Make some memory */
  if ((pre = (char *)calloc(strlen(query)+L_WORD, sizeof(char))) == NULL)
    errormsg("cpginput(): Couldn't allocate memory!");

  /* Initialise argument list */
  va_start(ap, fmt);

  /* Print the query */
  p = fmt;
  /* Check for defaults */
  if (*p != '%')
    sprintf(pre, "%s", query);
  else {
    sprintf(pre, "%s [", query);
    
    /* Step through the format string */
    for (; *p; p++) {

      /* Find '%', print everything else */
      if (*p != '%') {
	sprintf(pre+strlen(pre), "%c", *p);
	continue;
      }

      /* Get extra formatting information if present */
      p++;
      i = 0;
      deffmt[i++] = '%';
      while (*p == '0' || *p == '1' || *p == '2' || *p == '3' || *p == '4' ||
	     *p == '5' || *p == '6' || *p == '7' || *p == '8' || *p == '9' || 
	     *p == '.')
	deffmt[i++] = *p++;

      /* Print defaults */
      switch (*p) {
      case 'd':
	deffmt[i++] = 'd';
	deffmt[i] = '\0';
	ip = va_arg(ap, int *);
	sprintf(pre+strlen(pre), deffmt, *ip);
	break;
      case 'f':
	deffmt[i++] = 'f';
	deffmt[i] = '\0';
	fp = va_arg(ap, float *);
	sprintf(pre+strlen(pre), deffmt, *fp);
	break;
      case 'e':
	deffmt[i++] = 'e';
	deffmt[i] = '\0';
	fp = va_arg(ap, float *);
	sprintf(pre+strlen(pre), deffmt, *fp);
	break;
      case 'g':
	deffmt[i++] = 'g';
	deffmt[i] = '\0';
	fp = va_arg(ap, float *);
	sprintf(pre+strlen(pre), deffmt, *fp);
	break;
      case 'l':
	deffmt[i++] = *++p;
	deffmt[i] = '\0';
	/*
	p++;
	*/
	dp = va_arg(ap, double *);
	sprintf(pre+strlen(pre), deffmt, *dp);
	break;
      case 'c':
	deffmt[i++] = 'c';
	deffmt[i] = '\0';
	cp = va_arg(ap, char *);
	sprintf(pre+strlen(pre), deffmt, *cp);
	break;
      case 's':
	deffmt[i++] = 's';
	deffmt[i] = '\0';
	cp = va_arg(ap, char *);
	sprintf(pre+strlen(pre), deffmt, cp);
	break;
      default:
	errormsg("cpginput(): Don't know format type!");
	break;
      }
    }
    sprintf(pre+strlen(pre), "]");
  }
  
  flag = 1;
  while (flag) {
    
    /* Scan the data */
    cpggets(pre, answer, L_WORD);

    if (strlen(answer) == 0 && fmt[0] == '%') {
      /* Defaults are present and were selected; clean up and leave */
      va_end(ap);
      return;
    }
    
    /* Initialise again */
    va_end(ap);
    va_start(ap, fmt);
      
    /* Step through format string */
    flag = 0;
    for (p = fmt, pans = answer; *p; p++) {

      /* Find '%', skip everything else */
      if (*p != '%')
	continue;
      
      /* Get extra formatting information if present (only used for
	 characters) */
      p++;
      i = 0;
      deffmt[i++] = '%';
      while (*p == '0' || *p == '1' || *p == '2' || *p == '3' || *p == '4' ||
	     *p == '5' || *p == '6' || *p == '7' || *p == '8' || *p == '9' ||
	     *p == '.')
	deffmt[i++] = *p++;
	
      /* Read in data, flag errors */
      switch (*p) {
      case 'd':
	ip = va_arg(ap, int *);
	if (sscanf(pans, "%d", ip) != 1)
	  flag = 1;
	break;
      case 'f':
	fp = va_arg(ap, float *);
	if (sscanf(pans, "%f", fp) != 1)
	  flag = 1;
	break;
      case 'e':
	fp = va_arg(ap, float *);
	if (sscanf(pans, "%f", fp) != 1)
	  flag = 1;
	break;
      case 'g':
	fp = va_arg(ap, float *);
	if (sscanf(pans, "%f", fp) != 1)
	  flag = 1;
	break;  
      case 'l':
	p++;
	dp = va_arg(ap, double *);
	if (sscanf(pans, "%lf", dp) != 1)
	  flag = 1;
	break;
      case 'c':
	deffmt[i++] = 'c';
	deffmt[i] = '\0';
	cp = va_arg(ap, char *);
	if (sscanf(pans, deffmt, cp) != 1)
	  flag = 1;
	break;
      case 's':
	cp = va_arg(ap, char *);
	if (sscanf(pans, "%s", cp) != 1)
	  flag = 1;
	break;
      default:
	errormsg("cpginput(): Don't know format type!");
	break;
      }

      /* Move to next answer */
      pans = strchr(pans, ' ');
      if (pans == 0) {
	if (fmt[0] != '%' && *(p+1) != '\0')
	  flag = 1;
	break;
      } else 
	pans++;
    }

    /* Repeat input if error occured */
    if (flag)
      fprintf(stderr, "Bad input, try again!\n");
  }

  /* Clean up */
  va_end(ap);
  free(pre);

  return;
}
