/******************************************************************************
* Draw a polygon using fill-area attributes
******************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <cpgplot.h>
#include "geom.h"


void cpgpoli(point p[], int npts) {

  int          i;
  float        *x, *y;
  void         errormsg(char *, ...);


  if (npts < 2)
    errormsg("cpgpoli(): Bad arraysize: %d", npts);

  if ((x = (float *)calloc(npts, sizeof(float))) == NULL)
    errormsg("cpgpoli(): Couldn't allocate memory!");
  if ((y = (float *)calloc(npts, sizeof(float))) == NULL)
    errormsg("cpgpoli(): Couldn't allocate memory!");

  for (i = 0; i < npts; i++) {
    x[i] = (float)p[i].x;
    y[i] = (float)p[i].y;
  }

  cpgpoly(npts, x, y);

  /* Clean up */
  free(x);
  free(y);

  return;
}
