/****************************************************************************
* Calculate percentile
****************************************************************************/

#include <stdlib.h>
#include <math.h>
#include <gsl/gsl_sort.h>
#include <gsl/gsl_statistics.h>


double dpercentile(double array[], int n, double perc) {

  int        i;
  double     *data, p;
  void       errormsg(char *, ...);


  if (n <= 0)
    errormsg("dpercentile(): Bad arraysize: %d", n);

  if (perc < 0.0 || perc > 1.0)
    errormsg("dpercentile(): Bad percentile level: %f", perc);

  if ((data = (double *)calloc(n, sizeof(double))) == NULL)
    errormsg("dpercentile(): Couldn't allocate memory!");

  for (i = 0; i < n; i++)
    data[i] = array[i];

  gsl_sort(data, 1, n);
  p = gsl_stats_quantile_from_sorted_data(data, 1, n, perc);

  free(data);

  return p;
}
