/******************************************************************************
* Definitions for eltpsffit
******************************************************************************/

#ifndef J_ELTPSF_H

#define J_ELTPSF_H

#include "geom.h"
#include "img.h"

/* Definitions */

#define  L_WORD   2000   /* Longest string that can be handled */
#define  WS       35.0   /* Window size in cm */
#define  N_PTS1DF 10000  /* Number of points for displaying the 1D fit */
#define  P_CONT   1.0e-5 /* Maximum contrast of PSF profile */
#define  P_STEP   0.5    /* Profile step size in units of image pixel size */
#define  SHWHM    1.8955 /* Factor relating HWHM and width of sinc function */
#define  ADHWHM   1.6163 /* Factor relating HWHM and width of Airy disk */
#define  MOFN     4.765  /* Initial value for Moffat's n */
#define  COBS     0.28   /* Initial value for central obstruction */
#define  EBOXS    51     /* Initial value of smoothing box size */
#define  RESRNG   0.05   /* The fit should lie within this percantage
			    of the PSF */
#define  AIRC     60.0   /* Distance in units of width where the Airy disk
			    is cut off */

/* Structures */

/* Plotting environment */

typedef struct Env1dim {
  int     sym;
  float   ch;
  int     ls;
  int     noerrb;
  int     ic;
  int     res;
  int     logp;
  float   xmin;
  float   xmax;
  float   ymin;
  float   ymax;
  char    xlab[L_WORD];
  char    ylab[L_WORD];
  char    title[L_WORD];
} env1dim;


/* Model */

typedef struct Fitc1dim {
  char        type[5];
  int         npar;
  double      h;
  int         hfit;
  double      p;
  int         pi;
  int         pfit;
  double      w;
  int         wfit;
  double      q;
  int         qfit;
  double      hwhm;
  double      fmx;
  double      fmy;
} fitc1dim;

typedef struct Fit1dim {
  fitc1dim    *c;
  int         nc;
  int         type;       /* 1=x, 2=y, 3=radial profile */
} fit1dim;


typedef struct Fitcs2dim {
  char        type[5];
  int         npar;
  double      h;
  int         hfit;
  point       p;
  int         pi;
  int         pfit;
  double      w;
  int         wfit;
  double      q;
  int         qfit;
  double      rr;
  int         rrfit;
} fitcs2dim;

typedef struct Fits2dim {
  fitcs2dim   *c;
  int         nc;
} fits2dim;


typedef struct Fitc2dim {
  char        type[5];
  int         npar;
  double      h;
  int         hfit;
  point       p;
  int         pi;
  int         pfit;
  double      wx;
  double      wy;
  int         wtie;
  int         wfit;
  double      alpha;
  int         alphafit;
  double      q;
  int         qfit;
} fitc2dim;

typedef struct Fit2dim {
  fitc2dim    *c;
  int         nc;
} fit2dim;


/* Data */

typedef struct Data1dim {
  int            npts;
  double         *x;
  double         *y;
  double         *s;
  double         *r;
  unsigned short *d;
  float          *fx;
  float          *fy;
  float          *fs;
  float          *fr;
  float          *ly;
  float          *ls;
  float          *lr;
  float          *yd;
  float          *ys;
} data1dim;


typedef struct Datas2dim {
  image          *img;
  double         *x;
  double         *s;
  double         *r;
  unsigned short *d;
} datas2dim;


#endif
