/******************************************************************************
* Fit a spherically symmetric model to a 2D PSF
******************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <cpgplot.h>
#include "const.h"
#include "iact.h"
#include "eltpsffit.h"


datas2dim      datas2d;
fits2dim       fits2d;


void eltpsffits2d(image *psf) {

  int          i;
  void         errormsg(char *, ...), nferrormsg(char *, ...), 
               epfs2dwmodel(void), epfs2drmodel(void), epfs2ddofit(void);


  /* Some setup */
  datas2d.img = psf;
  fits2d.nc = 0;
  fits2d.c = NULL;

  /* Make space for the various data arrays */
  if ((datas2d.x = (double *)calloc(datas2d.img->npts, sizeof(double))) 
      == NULL)
    errormsg("eltpsffits2d(): Couldn't allocate memory!");
  if ((datas2d.s = (double *)calloc(datas2d.img->npts, sizeof(double))) 
      == NULL)
    errormsg("eltpsffits2d(): Couldn't allocate memory!");
  if ((datas2d.r = (double *)calloc(datas2d.img->npts, sizeof(double))) 
      == NULL)
    errormsg("eltpsffits2d(): Couldn't allocate memory!");
  if ((datas2d.d = (unsigned short *)calloc(datas2d.img->npts, 
					    sizeof(unsigned short))) == NULL)
    errormsg("eltpsffits2d(): Couldn't allocate memory!");

  /* Prepare data arrays */
  for (i = 0; i < datas2d.img->npts; i++) {
    datas2d.x[i] = (double)i;
    datas2d.s[i] = 0.0;
    datas2d.r[i] = 0.0;
    datas2d.d[i] = 0;
  }

  /* Read in a previously saved model; there must be one */
  epfs2drmodel();
  if (fits2d.nc == 0) {
    nferrormsg("Found no first guesses, nothing to fit!");
    free(datas2d.x);
    free(datas2d.s);
    free(datas2d.r);
    free(datas2d.d);
    return;
  }

  /* Need call to epfs2dfs here? */

  /* Fit */
  /*
  epfs2ddofit();
  */

  /* Save current model */
  epfs2dwmodel();

  /* Clean up */
  free(datas2d.x);
  free(datas2d.s);
  free(datas2d.r);
  free(datas2d.d);
  if (fits2d.nc > 0)
    free(fits2d.c);

  return;
}
