/*****************************************************************************
* Add a model component
*****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <cpgplot.h>
#include "iact.h"
#include "eltpsffit.h"


void epf1daddc(icom *com) {

  int               i, ti, n;
  extern fit1dim    fit1d;
  extern env1dim    env1d;
  void              errormsg(char *, ...), epf1dplot(void),
                    getcom(int, int, float, float, icom *), 
                    cpginput(char *, char *, ...),
                    cpgmline(float, float, float, float),
                    epf1dw2hwhm(fitc1dim *, int);


  /* Make space for the new component */
  fit1d.nc++;
  if ((fit1d.c = (fitc1dim *)realloc(fit1d.c, fit1d.nc * sizeof(fitc1dim))) 
      == NULL)
    errormsg("epf1daddc(): Couldn't reallocate memory!");
  
  /* Initialise the fitting flags */
  fit1d.c[fit1d.nc-1].hfit = 1;
  fit1d.c[fit1d.nc-1].wfit = 1;
  fit1d.c[fit1d.nc-1].pfit = 1;
  fit1d.c[fit1d.nc-1].qfit = 1;

  /* Get the type */
  if (com->cf) {
    if (sscanf(com->c, "%*s %s", fit1d.c[fit1d.nc-1].type) != 1)
      errormsg("epf1daddc(): Could not read component type!");
  } else {
    if (fit1d.nc == 1)
      strcpy(fit1d.c[fit1d.nc-1].type, "o");
    else
      strcpy(fit1d.c[fit1d.nc-1].type, "lx");
    cpginput("Component type?", "%s", fit1d.c[fit1d.nc-1].type);
  }
  fit1d.nc--;
  epf1dplot();
  fit1d.nc++;
  while ((strcmp(fit1d.c[fit1d.nc-1].type, "g") &&
	  strcmp(fit1d.c[fit1d.nc-1].type, "gx") &&
	  strcmp(fit1d.c[fit1d.nc-1].type, "l") &&
	  strcmp(fit1d.c[fit1d.nc-1].type, "lx") &&
	  strcmp(fit1d.c[fit1d.nc-1].type, "m") &&
	  strcmp(fit1d.c[fit1d.nc-1].type, "mx") &&
	  strcmp(fit1d.c[fit1d.nc-1].type, "s") &&
	  strcmp(fit1d.c[fit1d.nc-1].type, "sx") && 
	  strcmp(fit1d.c[fit1d.nc-1].type, "a") &&
	  strcmp(fit1d.c[fit1d.nc-1].type, "ax") &&
	  strcmp(fit1d.c[fit1d.nc-1].type, "o") &&
	  strcmp(fit1d.c[fit1d.nc-1].type, "ox") &&
	  strcmp(fit1d.c[fit1d.nc-1].type, "c")) ||
	 (fit1d.nc == 1 && 
	  fit1d.c[fit1d.nc-1].type[strlen(fit1d.c[fit1d.nc-1].type)-1] 
	  == 'x') ||
	 (fit1d.nc == 1 && !strcmp(fit1d.c[fit1d.nc-1].type, "c"))) {
    if (!strcmp(fit1d.c[fit1d.nc-1].type, "?")) {
      fprintf(stderr, "\nAvailable choices:\n\n");
      fprintf(stderr, "\tg\t\tGaussian\n \
\tl\t\tLorentzian\n \
\tm\t\tMoffat function\n \
\ts\t\tSinc function\n \
\ta\t\tAiry disk\n \
\to\t\tObstructed Airy disk\n \
\tc\t\tConstant\n\n\
Appending an \"x\" ties the position of the new component\n\
to that of an already existing one.\n\n");
    } else
      fprintf(stderr, "Invalid choice, try again!\n");
    cpginput("Component type?", "!%s", fit1d.c[fit1d.nc-1].type);
    fit1d.nc--;
    epf1dplot();
    fit1d.nc++;
  }

  /* Tied position */
  if (fit1d.c[fit1d.nc-1].type[strlen(fit1d.c[fit1d.nc-1].type)-1] == 'x') {
    /* Check for a unique component to tie to */
    n = 0;
    for (i = 0; i < fit1d.nc-1; i++)
      if (fit1d.c[i].pi == i && strcmp(fit1d.c[i].type, "c")) {
	n++;
	ti = i;
      }

    if (n != 1) {
      /* Didn't find one */
      if (com->cf) {
	if (sscanf(com->c, "%*s %*s %d", &ti) != 1 || ti < 0 || 
	    ti >= fit1d.nc-1 || fit1d.c[ti].pi != ti)
	  errormsg("epf1daddc(): Could not read tie component number!");
      } else {
	ti = 1;
	cpginput("Tie position to which component?", "%d", &ti);
      }
      ti--;
      fit1d.nc--;
      epf1dplot();
      fit1d.nc++;
      while (ti < 0 || ti >= fit1d.nc-1 || fit1d.c[ti].pi != ti || 
	     !strcmp(fit1d.c[ti].type, "c")) {
	fprintf(stderr, "Invalid choice, try again!\n");
	cpginput("Tie position to which component?", "!%d", &ti);
	ti--;
	fit1d.nc--;
	epf1dplot();
	fit1d.nc++;
      }
    }
    fit1d.c[fit1d.nc-1].pi = ti;
    fit1d.c[fit1d.nc-1].pfit = 0;
    fit1d.c[fit1d.nc-1].type[strlen(fit1d.c[fit1d.nc-1].type)-1] = '\0';
  } else if (!strcmp(fit1d.c[fit1d.nc-1].type, "c")) {
    fit1d.c[fit1d.nc-1].pi = 0;
    fit1d.c[fit1d.nc-1].pfit = 0;
    /*
  } else if (fit1d.type == 3) {
    fit1d.c[fit1d.nc-1].pi = fit1d.nc - 1;
    fit1d.c[fit1d.nc-1].pfit = 0;
    fit1d.c[fit1d.nc-1].p = 0.0;
    */
  } else
    fit1d.c[fit1d.nc-1].pi = fit1d.nc - 1;

  /* Number of parameters */
  if (!strcmp(fit1d.c[fit1d.nc-1].type, "c"))
    fit1d.c[fit1d.nc-1].npar = 1;
  else if (!strcmp(fit1d.c[fit1d.nc-1].type, "o") || 
	   !strcmp(fit1d.c[fit1d.nc-1].type, "m")) 
    fit1d.c[fit1d.nc-1].npar = (fit1d.c[fit1d.nc-1].pi == fit1d.nc - 1) ? 4 
      : 3;
  else 
    fit1d.c[fit1d.nc-1].npar = (fit1d.c[fit1d.nc-1].pi == fit1d.nc - 1) ? 3 
      : 2;

  /* Additional parameter */
  if (!strcmp(fit1d.c[fit1d.nc-1].type, "o"))
    fit1d.c[fit1d.nc-1].q = COBS;
  else if (!strcmp(fit1d.c[fit1d.nc-1].type, "m"))
    fit1d.c[fit1d.nc-1].q = MOFN;
  else {
    fit1d.c[fit1d.nc-1].q = 0.0;
    fit1d.c[fit1d.nc-1].qfit = 0;
  }

  /* Height and position */
  cpgsci(7);
  if (fit1d.c[fit1d.nc-1].pfit == 1) {
    fprintf(stderr, "\nMark the central position and maximum of component\
 %d...\n", fit1d.nc);
    getcom(7, 1, com->x, com->y, com);
    fit1d.c[fit1d.nc-1].p = com->x;
    fit1d.c[fit1d.nc-1].h = com->y;
    cpgsci(fit1d.nc+1);
    cpgmline(env1d.xmin, fit1d.c[fit1d.nc-1].h, env1d.xmax, 
	     fit1d.c[fit1d.nc-1].h);
    cpgmline(fit1d.c[fit1d.nc-1].p, env1d.ymin, fit1d.c[fit1d.nc-1].p, 
	     env1d.ymax);
    cpgsci(7);
  } else {
    cpgsci(fit1d.nc+1);
    cpgmline(fit1d.c[fit1d.c[fit1d.nc-1].pi].p, env1d.ymin, 
	     fit1d.c[fit1d.c[fit1d.nc-1].pi].p, env1d.ymax);
    cpgsci(7);
    fprintf(stderr, "\nMark the maximum of component %d...\n", fit1d.nc);
    com->x = fit1d.c[fit1d.c[fit1d.nc-1].pi].p;
    getcom(5, 1, com->x, com->y, com);
    fit1d.c[fit1d.nc-1].h = com->y;
    cpgsci(fit1d.nc+1);
    cpgmline(env1d.xmin, fit1d.c[fit1d.nc-1].h, env1d.xmax, 
	     fit1d.c[fit1d.nc-1].h);
    cpgsci(7);
  }
  if (env1d.logp)
    fit1d.c[fit1d.nc-1].h = pow(10.0, fit1d.c[fit1d.nc-1].h);
  
  /* Width */
  if (!strcmp(fit1d.c[fit1d.nc-1].type, "c")) {
    fit1d.c[fit1d.nc-1].w = 0.0;
    fit1d.c[fit1d.nc-1].wfit = 0;
  } else { 
    fprintf(stderr, "...and now one half-maximum point...\n");
    com->y = fit1d.c[fit1d.nc-1].h / 2.0;
    if (env1d.logp)
      com->y = log10(com->y);
    cpgsci(fit1d.nc+1);
    cpgmline(env1d.xmin, com->y, env1d.xmax, com->y);
    cpgsci(7);
    getcom(6, 0, com->x, com->y, com);
    fit1d.c[fit1d.nc-1].hwhm = fabs(fit1d.c[fit1d.c[fit1d.nc-1].pi].p 
				    - com->x);
    epf1dw2hwhm(&(fit1d.c[fit1d.nc-1]), 1);
  }

  return;
}
