/*****************************************************************************
* Delete a model component
*****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "iact.h"
#include "eltpsffit.h"


void epf1ddelc(icom *com) {

  int               i, j, n;
  float             y;
  extern fit1dim    fit1d;
  extern env1dim    env1d;
  int               idxfitc1d(fitc1dim *, int, float, float, int *);
  void              errormsg(char *, ...), nferrormsg(char *, ...);

  
  if (fit1d.nc == 0) {
    nferrormsg("Nothing to delete!");
    return;
  }
  
  y = (env1d.logp) ? pow(10.0, com->y) : com->y;

  /* Find the component */
  n = idxfitc1d(fit1d.c, fit1d.nc, com->x, y, &i);

  for (i = 0; i < fit1d.nc; i++)
    if (i != n && fit1d.c[i].pi == n) {
      nferrormsg("Other components are tied to component %d!", n+1);
      return;
    }

  for (i = n+1; i < fit1d.nc; i++) {
    fit1d.c[i-1] = fit1d.c[i];
    for (j = 0; j < fit1d.nc; j++)
      if (fit1d.c[j].pi == i)
	fit1d.c[j].pi = i - 1;
  }
  fit1d.nc--;

  if ((fit1d.c = (fitc1dim *)realloc(fit1d.c, fit1d.nc * sizeof(fitc1dim))) 
      == NULL && fit1d.nc != 0)
    errormsg("epf1ddelc(): Couldn't reallocate memory!");
  
  return;
}
