/****************************************************************************
* Fit data with multiple components
****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <gsl/gsl_vector.h>
#include <gsl/gsl_matrix.h>
#include "eltpsffit.h"


void epf1ddofit(void) {

  int                i, j, npts, na;
  double             *x, *y, *s, *a, *err, chisq;
  extern data1dim    data1d;
  extern fit1dim     fit1d;
  int                fepfmc1d(const gsl_vector *, void *, gsl_vector *,
			      gsl_matrix *);
  void               errormsg(char *, ...), nferrormsg(char *, ...),
                     epf1dfs(void), epf1dw2hwhm(fitc1dim *, int),
                     nlfit(double *, double *, double *, int, double *,
			   double *, int, double *, 
			   int (*)(const gsl_vector *, void *, gsl_vector *,
				   gsl_matrix *));


  if (fit1d.nc == 0) {
    nferrormsg("Nothing to fit!");
    return;
  }

  /* Count the number of parameters to be fit */
  na = 0;
  for (i = 0; i < fit1d.nc; i++)
    na += fit1d.c[i].npar;

  /* Allocate some memory */
  if ((x = (double *)calloc(data1d.npts, sizeof(double))) == NULL)
    errormsg("epf1ddofit(): Couldn't allocate memory!");
  if ((y = (double *)calloc(data1d.npts, sizeof(double))) == NULL)
    errormsg("epf1ddofit(): Couldn't allocate memory!");
  if ((s = (double *)calloc(data1d.npts, sizeof(double))) == NULL)
    errormsg("epf1ddofit(): Couldn't allocate memory!");
  if ((a = (double *)calloc(na, sizeof(double))) == NULL)
    errormsg("epf1ddofit(): Couldn't allocate memory!");
  if ((err = (double *)calloc(na, sizeof(double))) == NULL)
    errormsg("epf1ddofit(): Couldn't allocate memory!");

  /* Copy the data */
  npts = 0;
  for (i = 0; i < data1d.npts; i++)
    if (!data1d.d[i]) {
      x[npts] = data1d.x[i];
      y[npts] = data1d.y[i];
      s[npts] = data1d.s[i];
      npts++;
    }

  /* Copy the parameters over */
  j = 0;
  for (i = 0; i < fit1d.nc; i++) {
    a[j++] = fit1d.c[i].h;
    if (strcmp(fit1d.c[i].type, "c"))
      a[j++] = fit1d.c[i].w;
    if (!strcmp(fit1d.c[i].type, "o") || !strcmp(fit1d.c[i].type, "m"))
      a[j++] = fit1d.c[i].q;
    if (fit1d.c[i].pi == i)
      a[j++] = fit1d.c[i].p;
  }
  if (j != na)
    errormsg("epf1ddofit(): Something is very wrong!");

  /* Do the fit */
  nlfit(x, y, s, npts, a, err, na, &chisq, fepfmc1d);

  /* Copy the parameters back */
  j = 0;
  for (i = 0; i < fit1d.nc; i++) {
    fit1d.c[i].h = a[j++];
    if (strcmp(fit1d.c[i].type, "c"))
      fit1d.c[i].w = a[j++];
    if (!strcmp(fit1d.c[i].type, "o") || !strcmp(fit1d.c[i].type, "m"))
      fit1d.c[i].q = a[j++];
    if (fit1d.c[i].pi == i)      
      fit1d.c[i].p = a[j++];
    epf1dw2hwhm(&(fit1d.c[i]), 0);
  }
  
  /* Print results */
  printf("\nResult:\n");
  for (i = 0; i < na; i++)
    printf("a_%-2d = %-12g +/- %g\n", i, a[i], err[i]);
  epf1dfs();

  /* Clean up */
  free(x);
  free(y);
  free(s);
  free(a);
  free(err);

  return;
}
