/*****************************************************************************
* Edit a model component
*****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <cpgplot.h>
#include "iact.h"
#include "eltpsffit.h"


void epf1deditc(icom *com) {

  int               i, n, pp;
  float             y;
  extern fit1dim    fit1d;
  extern env1dim    env1d;
  int               idxfitc1d(fitc1dim *, int, float, float, int *);
  double            epf1dh2q(double);
  void              errormsg(char *, ...), nferrormsg(char *, ...),
                    getcom(int, int, float, float, icom *),
                    cpginput(char *, char *, ...),
                    cpgmline(float, float, float, float),
                    epf1dw2hwhm(fitc1dim *, int);


  if (fit1d.nc == 0) {
    nferrormsg("Nothing to edit!");
    return;
  }

  y = (env1d.logp) ? pow(10.0, com->y) : com->y;
  
  /* Find the component */
  n = idxfitc1d(fit1d.c, fit1d.nc, com->x, y, &pp);

  if (com->c[0] == 'x') {
    /* Fix or release a fit component's parameter */
    if (pp == 1) {
      if (fit1d.c[n].pi != n)
	/* Position is tied to other component, must mean height */
	fit1d.c[n].hfit = !(fit1d.c[n].hfit);
      else {
	if (com->cf) {
	  if (sscanf(com->c, "%*s %c", &(com->c[10])) != 1)
	    errormsg("epf1deditc(): Could not read what to fix/release!");
	} else {
	  com->c[0] = 'h';
	  cpginput("Fix/release height or position?", "%c", &(com->c[10]));
	}
	if (com->c[10] == 'h')
	  fit1d.c[n].hfit = !(fit1d.c[n].hfit);
	else
	  fit1d.c[n].pfit = !(fit1d.c[n].pfit);
      }

    } else if (pp == 2)
      fit1d.c[n].wfit = !(fit1d.c[n].wfit);
    else if (pp == 3)
      fit1d.c[n].qfit = !(fit1d.c[n].qfit);
    else
      errormsg("epf1deditc(): Something is very wrong!");

  } else {
    /* Edit a fit component's parameter */
    if (pp == 1) {
      if (!fit1d.c[n].hfit && !fit1d.c[n].pfit) {
	nferrormsg("Parameters are fixed!");
	return;
      }
      if (env1d.logp)
	fit1d.c[n].h = log10(fit1d.c[n].h);
      com->x = fit1d.c[fit1d.c[n].pi].p;
      com->y = fit1d.c[n].h;
      if (fit1d.c[n].hfit && fit1d.c[n].pfit) {
	/* Height and position */
	cpgsci(n+2);
	cpgmline(env1d.xmin, fit1d.c[n].h, env1d.xmax, fit1d.c[n].h);
	cpgmline(fit1d.c[fit1d.c[n].pi].p, env1d.ymin, 
		 fit1d.c[fit1d.c[n].pi].p, env1d.ymax);
	cpgsci(7);
	getcom(7, 1, com->x, com->y, com);
	fit1d.c[n].p = com->x;
	fit1d.c[n].h = com->y;
      } else if (fit1d.c[n].hfit) {
	/* Height only */
	cpgsci(n+2);
	cpgmline(env1d.xmin, fit1d.c[n].h, env1d.xmax, fit1d.c[n].h);
	cpgsci(7);
	getcom(5, 1, com->x, com->y, com);
	fit1d.c[n].h = com->y;
      } else {
	/* Position only */
	cpgsci(n+2);
	cpgmline(fit1d.c[fit1d.c[n].pi].p, env1d.ymin,
		 fit1d.c[fit1d.c[n].pi].p, env1d.ymax);
	cpgsci(7);
	getcom(6, 1, com->x, com->y, com);
	fit1d.c[n].p = com->x;
      }
      if (env1d.logp)
	fit1d.c[n].h = pow(10.0, fit1d.c[n].h);
    
    } else if (pp == 2) {
      /* Width */
      if (!fit1d.c[n].wfit) {
	nferrormsg("Parameter is fixed!");
	return;
      }
      cpgsci(n+2);
      cpgmline(fit1d.c[fit1d.c[n].pi].p + fit1d.c[n].hwhm, env1d.ymin, 
	       fit1d.c[fit1d.c[n].pi].p + fit1d.c[n].hwhm, env1d.ymax);
      cpgsci(7);
      com->x = fit1d.c[n].hwhm + fit1d.c[fit1d.c[n].pi].p;
      com->y = fit1d.c[n].h / 2.0;
      if (env1d.logp)
	com->y = log10(com->y);
      getcom(6, 1, com->x, com->y, com);
      fit1d.c[n].hwhm = fabs(fit1d.c[fit1d.c[n].pi].p - com->x);
      epf1dw2hwhm(&(fit1d.c[n]), 1);

    } else if (pp == 3) {
      if (!fit1d.c[n].qfit) {
	nferrormsg("Parameter is fixed!");
	return;
      }
      if (!strcmp(fit1d.c[n].type, "o")) {
	/* Contrast between central and first peak */
	fit1d.c[n].fmy *= fit1d.c[n].h;
	if (env1d.logp)
	  fit1d.c[n].fmy = log10(fit1d.c[n].fmy);
	cpgsci(n+2);
	cpgmline(env1d.xmin, fit1d.c[n].fmy, env1d.xmax, fit1d.c[n].fmy);
	cpgsci(7);
	com->x = fit1d.c[fit1d.c[n].pi].p + fit1d.c[n].fmx;
	com->y = fit1d.c[n].fmy;
	getcom(5, 1, com->x, com->y, com);
	fit1d.c[n].fmy = com->y;
	if (env1d.logp)
	  fit1d.c[n].fmy = pow(10.0, fit1d.c[n].fmy);
	fit1d.c[n].fmy /= fit1d.c[n].h;
	fit1d.c[n].q = epf1dh2q(fit1d.c[n].fmy);
	epf1dw2hwhm(&(fit1d.c[n]), 1);

      } else if (!strcmp(fit1d.c[n].type, "m")) {
	/* Moffat index */
	cpgsci(n+2);
	cpgmline(fit1d.c[fit1d.c[n].pi].p + fit1d.c[n].fmx, env1d.ymin, 
		 fit1d.c[fit1d.c[n].pi].p + fit1d.c[n].fmx, env1d.ymax);
	cpgsci(7);
	com->x = fit1d.c[fit1d.c[n].pi].p + fit1d.c[n].fmx;
	com->y = fit1d.c[n].h / 3.0;
	if (env1d.logp)
	  com->y = log10(com->y);
	getcom(6, 1, com->x, com->y, com);
	for (i = 0; i < 10; i++) {
	  fit1d.c[n].q = log10(3.0) 
	    / log10(pow((fit1d.c[fit1d.c[n].pi].p - com->x) 
			/ fit1d.c[n].w, 2.0) + 1.0);
	  epf1dw2hwhm(&(fit1d.c[n]), 1);
	}

      } else
	errormsg("epf1deditc(): Something is very wrong!");
    
    } else
      errormsg("epf1deditc(): Something is very wrong!");
  }

  return;
}
