/*****************************************************************************
* Evaluate the current fit
*****************************************************************************/

#include <string.h>
#include <math.h>
#include "const.h"
#include "eltpsffit.h"


double epf1deval(double x, int ic) {

  int             i, imin, imax;
  double          arg, w, res;
  extern fit1dim  fit1d;
  double          sinc(double), airy_disk(double, double),
                  airy_disk_obs(double, double, double);
  void            errormsg(char *, ...);


  imin = 0;
  imax = fit1d.nc;
  if (ic >= 0 && ic < fit1d.nc) {
    imin = ic; 
    imax = ic + 1;
  }

  res = 0.0;
  for (i = imin; i < imax; i++) {
    if (!strcmp(fit1d.c[i].type, "g")) {
      arg = (x - fit1d.c[fit1d.c[i].pi].p) / fit1d.c[i].w;
      res += fit1d.c[i].h * exp(-arg * arg);

    } else if (!strcmp(fit1d.c[i].type, "l")) {
      arg = (x - fit1d.c[fit1d.c[i].pi].p) / fit1d.c[i].w;
      res += fit1d.c[i].h / (arg * arg + 1.0);

    } else if (!strcmp(fit1d.c[i].type, "m")) {
      arg = (x - fit1d.c[fit1d.c[i].pi].p) / fit1d.c[i].w;
      res += fit1d.c[i].h / pow(arg * arg + 1.0, fit1d.c[i].q);
      
    } else if (!strcmp(fit1d.c[i].type, "s")) {
      arg = (x - fit1d.c[fit1d.c[i].pi].p) / fit1d.c[i].w;
      res += fit1d.c[i].h * sinc(arg);

    } else if (!strcmp(fit1d.c[i].type, "a")) {
      arg = (x - fit1d.c[fit1d.c[i].pi].p) * RPMAS;
      w = fit1d.c[i].w * RPMAS;
      if (fabs(arg / w) < AIRC)
	res += fit1d.c[i].h * airy_disk(w, arg);

    } else if (!strcmp(fit1d.c[i].type, "o")) {
      arg = (x - fit1d.c[fit1d.c[i].pi].p) * RPMAS;
      w = fit1d.c[i].w * RPMAS;
      if (fabs(arg / w) < AIRC)
	res += fit1d.c[i].h * airy_disk_obs(w, fit1d.c[i].q, arg);

    } else if (!strcmp(fit1d.c[i].type, "c")) {
      res += fit1d.c[i].h;

    } else
      errormsg("epf1deval(): Unknown component type: %s", fit1d.c[i].type);
  }

  return res;
}
