/****************************************************************************
* Print fit statistics of current model
****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <gsl/gsl_statistics.h>
#include "eltpsffit.h"


void epf1dfs(void) {

  int                i, npts, na;
  double             *r, chisq, rms, help;
  extern data1dim    data1d;
  extern fit1dim     fit1d;
  double             epf1deval(double, int);
  void               errormsg(char *, ...);


  /* Count the number of parameters to be fit */
  na = 0;
  for (i = 0; i < fit1d.nc; i++)
    na += fit1d.c[i].npar;

  /* Allocate some memory */
  if ((r = (double *)calloc(data1d.npts, sizeof(double))) == NULL)
    errormsg("epf1dfs(): Couldn't allocate memory!");

  /* Calculate the residuals */
  for (i = 0; i < data1d.npts; i++) {
    help = epf1deval(data1d.x[i], fit1d.nc);
    data1d.r[i] = data1d.y[i] - help;
    data1d.fr[i] = data1d.r[i];
    if (fit1d.nc > 0)
      data1d.lr[i] = (data1d.y[i] / help <= 0.0) ? 0.0 : 
	log10(data1d.y[i] / help);
  }

  /* Calculate chi^2 */
  chisq = 0.0;
  for (i = 0; i < data1d.npts; i++)
    if (!data1d.d[i])
      chisq += (data1d.r[i] / data1d.s[i]) * (data1d.r[i] / data1d.s[i]);

  /* Calculate the rms of the residuals */
  npts = 0;
  for (i = 0; i < data1d.npts; i++)
    if (!data1d.d[i])
      r[npts++] = data1d.r[i];
  rms = gsl_stats_sd(r, 1, npts);

  /* Print */
  printf("\nCurrent model:\n");
  for (i = 0; i < fit1d.nc; i++)
    printf("%s   %12.5e %d   %.5e %d %d   %.5e %d   %.4e %d\n",
	   fit1d.c[i].type, fit1d.c[i].h, fit1d.c[i].hfit,
	   fit1d.c[fit1d.c[i].pi].p, fit1d.c[i].pi, fit1d.c[i].pfit,
	   fit1d.c[i].w, fit1d.c[i].wfit, fit1d.c[i].q, fit1d.c[i].qfit);

  printf("\nStatistics of current model:\n");
  printf("npts = %d   nparam = %d   ndof = %d\n", npts, na, npts - na);
  printf("chi^2 = %g    chi^2/ndof = %g\n", chisq, chisq / (float)(npts - na));
  printf("rms of residuals = %g\n", rms);

  /* Clean up */
  free(r);

  return;
}
