/*****************************************************************************
* Compute q from the relative height of the first peak
*****************************************************************************/

double epf1dh2q(double h) {

  double    h2;


  if (h < 0.0176)
    return 0.01;
  else if (h > 0.162)
    return 0.99;

  h2 = h * h;  
  return -5.7766e-01 * (1.0 - 9.0262e+01 * h + 2.1899e+03 * h2 
			- 2.7134e+04 * h2*h + 1.5929e+05 * h2*h2
			- 3.5739e+05 * h2*h2*h);
}
