/***************************************************************************
* Plot data and model
***************************************************************************/

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <cpgplot.h>
#include "eltpsffit.h"


void epf1dplot(void) {
  
  int                  i, j;
  extern float         xfit[], yfit[];
  extern data1dim      data1d;
  extern fit1dim       fit1d;
  extern env1dim       env1d;
  double               epf1deval(double, int);
  void                 cpgmline(float, float, float, float);
  

  cpgbbuf();

  /* Environment */
  cpgeras();
  cpgsch(env1d.ch);
  cpgvstd();
  cpgswin(env1d.xmin, env1d.xmax, env1d.ymin, env1d.ymax);
  cpgsci(15);
  cpgrect(env1d.xmin, env1d.xmax, env1d.ymin, env1d.ymax);
  cpgsci(5);
  cpgbox("BCTS", 0.0, 0, "BCTS", 0.0, 0);
  cpgsci(7);
  cpgbox("N", 0.0, 0, "N", 0.0, 0);
  if (env1d.res && env1d.logp) {
    cpgsci(8);
    cpgsls(4);
    cpgmline(env1d.xmin, log10(1.0+RESRNG), env1d.xmax, log10(1.0+RESRNG));
    cpgmline(env1d.xmin, log10(1.0-RESRNG), env1d.xmax, log10(1.0-RESRNG));
    cpgsls(1);
  }
  cpgsci(3);
  cpglab(env1d.xlab, env1d.ylab, env1d.title);
  cpgsci(1);

  /* Draw the data */
  cpgpt(data1d.npts, data1d.fx, data1d.yd, env1d.sym);
  if (!env1d.noerrb) {
    cpgerrb(2, data1d.npts, data1d.fx, data1d.yd, data1d.ys, 1.0);
    cpgerrb(4, data1d.npts, data1d.fx, data1d.yd, data1d.ys, 1.0);
  }

  /* Mark deleted points */
  cpgsci(2);
  cpgsch(2.0*env1d.ch);
  for (i = 0; i < data1d.npts; i++)
    if (data1d.d[i])
      cpgpt1(data1d.fx[i], data1d.yd[i], 5);
  cpgsch(env1d.ch);
  cpgsci(1);

  /* Plot the current fit */
  cpgsls(env1d.ls);
  cpgsci(2);
  if (!env1d.res) {
    if (env1d.ic) {
      /* Individual components */
      for (j = 0; j < fit1d.nc; j++) {
	for (i = 0; i < N_PTS1DF; i++) {
	  yfit[i] = epf1deval(xfit[i], j);
	  if (env1d.logp)
	    yfit[i] = log10(fabs(yfit[i]));
	}
	cpgsci(j+2);
	if (env1d.logp && fit1d.c[j].h < 0.0)
	  cpgsls(2);
	cpgline(N_PTS1DF, xfit, yfit);
	cpgsls(env1d.ls);

	/* Handles */
	if (!env1d.logp) {
	  /* Position and height */
	  if (fit1d.c[j].pfit && fit1d.c[j].hfit)
	    i = 23;
	  else if (fit1d.c[j].pfit)
	    i = 12;
	  else if (fit1d.c[j].hfit)
	    i = 11;
	  else
	    i = 17;
	  cpgpt1(fit1d.c[fit1d.c[j].pi].p, fit1d.c[j].h, i);

	  /* Width */
	  if (strcmp(fit1d.c[j].type, "c")) {
	    i = (fit1d.c[j].wfit == 1) ? 23 : 17;
	    cpgpt1(fit1d.c[fit1d.c[j].pi].p + fit1d.c[j].hwhm,
		   fit1d.c[j].h / 2.0, i);
	  }
	  
	  /* Additional handle */
	  if (!strcmp(fit1d.c[j].type, "o") || !strcmp(fit1d.c[j].type, "m")) {
	    i = (fit1d.c[j].qfit == 1) ? 23 : 17;
	    cpgpt1(fit1d.c[fit1d.c[j].pi].p + fit1d.c[j].fmx, 
		   fit1d.c[j].h * fit1d.c[j].fmy, i);
	  }

	} else {
	  if (fit1d.c[j].h > 0.0) {
	    /* Position and height */
	    if (fit1d.c[j].pfit && fit1d.c[j].hfit)
	      i = 23;
	    else if (fit1d.c[j].pfit)
	      i = 12;
	    else if (fit1d.c[j].hfit)
	      i = 11;
	    else
	      i = 17;
	    cpgpt1(fit1d.c[fit1d.c[j].pi].p, log10(fit1d.c[j].h), i);
	    
	    /* Width */
	    if (strcmp(fit1d.c[j].type, "c")) {
	      i = (fit1d.c[j].wfit == 1) ? 23 : 17;
	      cpgpt1(fit1d.c[fit1d.c[j].pi].p + fit1d.c[j].hwhm,
		     log10(fit1d.c[j].h / 2.0), i);
	    }
	    
	    /* Additional handle */
	    if (!strcmp(fit1d.c[j].type, "o") || 
		!strcmp(fit1d.c[j].type, "m")) {
	      i = (fit1d.c[j].qfit == 1) ? 23 : 17;
	      cpgpt1(fit1d.c[fit1d.c[j].pi].p + fit1d.c[j].fmx, 
		     log10(fit1d.c[j].h * fit1d.c[j].fmy), i);
	    }
	  }
	}
      }
      cpgsci(1);
    }
    
    /* Sum of components */
    for (i = 0; i < N_PTS1DF; i++) {
      yfit[i] = epf1deval(xfit[i], fit1d.nc);
      if (env1d.logp)
	yfit[i] = (yfit[i] <= 0.0) ? -40.0 : log10(yfit[i]);
    }
    cpgline(N_PTS1DF, xfit, yfit);
    
  } else
    cpgmline(env1d.xmin, 0.0, env1d.xmax, 0.0);
  cpgsls(1);

  cpgsci(1); 
  cpgebuf();

  return;
}
