/****************************************************************************
* Read in a model
****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <unistd.h>
#include "const.h"
#include "eltpsffit.h"


void epf1drmodel(void) {

  int                i;
  char               *buf, nbuffer[L_WORD], buffer[L_WORD];
  extern char        psfimgname[];
  FILE               *data_file;
  extern data1dim    data1d;
  extern fit1dim     fit1d;
  int                nlines(FILE *);
  FILE               *faskropen(char *, char *, int);
  void               errormsg(char *, ...), epf1dw2hwhm(fitc1dim *, int);


  /* Read in a previously saved model */
  /* Make the file name */
  strcpy(nbuffer, psfimgname);
  buf = strstr(nbuffer, ".fit");

  if (fit1d.type == 1) {
    strcpy(buf, ".1dxf");
    if (access(nbuffer, R_OK) == -1) {
      strcpy(buf, ".1dyf");
      if (access(nbuffer, R_OK) == -1)
	return;
    }
  } else if (fit1d.type == 2) {
    strcpy(buf, ".1dyf");
    if (access(nbuffer, R_OK) == -1) {
      strcpy(buf, ".1dxf");
      if (access(nbuffer, R_OK) == -1)
	return;
    }
  } else if (fit1d.type == 3) {
    strcpy(buf, ".1drf");
    if (access(nbuffer, R_OK) == -1) {
      strcpy(buf, ".1dxf");
      if (access(nbuffer, R_OK) == -1) {
	strcpy(buf, ".1dyf");
	if (access(nbuffer, R_OK) == -1)
	  return;
      }
    }
  } else
    errormsg("epf1drmodel(): Unknown model type: %d!", fit1d.type);

  /* Open the file */
  if ((data_file = faskropen("1D model file name?", nbuffer, 3)) == NULL)
    errormsg("epf1drmodel(): Couldn't open %s!", nbuffer);
  
  fit1d.nc = nlines(data_file);

  /* Make some memory */
  if ((fit1d.c = (fitc1dim *)realloc(fit1d.c, fit1d.nc * sizeof(fitc1dim))) 
      == NULL)
    errormsg("epf1drmodel(): Couldn't reallocate memory!");

  /* Read in the data */
  i = 0;
  while (i < fit1d.nc && fgets(buffer, L_WORD, data_file) != NULL)
    if (buffer[0] != '#') {
      if (sscanf(buffer, "%s %lf %lf %d %lf %lf", fit1d.c[i].type,
		 &(fit1d.c[i].h), &(fit1d.c[i].p), &(fit1d.c[i].pi),
		 &(fit1d.c[i].w), &(fit1d.c[i].q)) != 6)
	errormsg("epf1drmodel(): Having trouble reading the data!");

      /* When reading an x or y model to be used in a radial profile fit
         set all positions to 0 */
      if (fit1d.type == 3 && strcmp(buf, ".1drf"))
	fit1d.c[i].p = 0.0;

      /* Number of parameters */
      if (!strcmp(fit1d.c[i].type, "c")) {
	fit1d.c[i].npar = 1;
	fit1d.c[i].qfit = 0;
      } else if (!strcmp(fit1d.c[i].type, "o") || 
		 !strcmp(fit1d.c[i].type, "m")) {
	fit1d.c[i].npar = (fit1d.c[i].pi == i) ? 4 : 3;
	fit1d.c[i].qfit = 1;
      } else {
	fit1d.c[i].npar = (fit1d.c[i].pi == i) ? 3 : 2;
	fit1d.c[i].qfit = 0;
      }

      /* Initialise the rest of the fitting flags */
      fit1d.c[i].hfit = 1;
      fit1d.c[i].wfit = (!strcmp(fit1d.c[i].type, "c")) ? 0 : 1;
      fit1d.c[i].pfit = (fit1d.c[i].pi != i || (fit1d.type == 3 && i == 0)) ? 
	0 : 1;

      /* HWHM and first maximum */
      epf1dw2hwhm(&(fit1d.c[i]), 0);

      i++;
    }
  fit1d.nc = i;
  fclose(data_file);
  fprintf(stderr, "\nRead model.\n");

  /* Read in weights and rejection flag */
  /* Make the file name */
  if (fit1d.type == 1)
    strcpy(buf, ".1dxwr");
  else if (fit1d.type == 2)
    strcpy(buf, ".1dywr");
  else if (fit1d.type == 3)
    strcpy(buf, ".1drwr");
  else
    errormsg("epf1drmodel(): Unknown model type: %d!", fit1d.type);

  if ((data_file = faskropen("File name?", nbuffer, 4)) != NULL) {
    /* Read in the data */
    i = 0;
    while (i < data1d.npts && fgets(buffer, L_WORD, data_file) != NULL)
      if (buffer[0] != '#') {
	if (sscanf(buffer, "%lf %hu", &(data1d.s[i]), &(data1d.d[i])) != 2)
	  errormsg("epf1drmodel(): Having trouble reading the data!");
	data1d.fs[i] = data1d.s[i];
	data1d.ls[i] = (data1d.y[i] <= 0.0) ? 1.0e6 : 
	  data1d.s[i] / data1d.y[i] * LOGE;
	i++;
      }
    fclose(data_file);
    if (i != data1d.npts)
      errormsg("epf1drmodel(): Something is very wrong!");
    fprintf(stderr, "\nRead weights and rejection flags.\n");
  }

  return;
}
