/****************************************************************************
* Set the errors
****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <gsl/gsl_math.h>
#include <gsl/gsl_statistics.h>
#include <cpgplot.h>
#include "const.h"
#include "iact.h"
#include "eltpsffit.h"


void epf1dse(icom *com) {

  int                    i, npts, imin, imax;
  static int             bs=EBOXS, new=1;
  static unsigned short  *del;
  float                  *fmean, *fx, *lrms;
  double                 *mean, *rms;
  static sline           efit;
  extern data1dim        data1d;
  extern env1dim         env1d;
  int                    sidxnval(float *, int, float);
  double                 dpercentile(double *, int, double);
  void                   errormsg(char *, ...), nferrormsg(char *, ...),
                         epf1dplot(void),
                         lin_fit_s(float *, float *, int, sline *),
                         cpginput(char *, char *, ...), cpgdsline(sline),
                         getcom(int, int, float, float, icom *);


  fprintf(stderr, "\nEntering mode to set fitting weights...\n");

  if (new == 1) {
    /* Prepare an array to flag rejected points */
    new = 0;

    if ((del = (unsigned short *)calloc(data1d.npts, sizeof(unsigned short))) 
	== NULL)
      errormsg("epf1dse(): Couldn't allocate memory!");

    for (i = 0; i < data1d.npts; i++)
      del[i] = 0;
  }


  while (1) {
    
    getcom(0, 1, com->x, com->y, com);
    
    if (com->c[0] == 'q') {
      /* Quit */
      break;

    } else if (com->c[0] == '?') {
      /* Help menu */
      fprintf(stderr, "\nList of interactive commands:\n\n");
      fprintf(stderr, "\t?\t\tprint this list\n \
\t1\t\tset weights propto PSF^0   and return to normal mode\n \
\t2\t\tset weights propto PSF^1/2 and return to normal mode\n \
\t3\t\tset weights propto PSF^1   and return to normal mode\n \
\tf\t\tdetermine proportionality constant for the above\n \
\t\t\tfrom a fit of the rms of the smoothed residuals\n \
\tb\t\tset boxcar smoothing size (must be uneven) for\n \
\t\t\tthe above fit\n \
\tk\t\tchoose regions to exclude from above fit\n \
\tu\t\tundo exclusion region\n \
\tq\t\treturn to normal mode without doing anything\n\n");
    
    } else if (com->c[0] == 'f') {

      /* Make some memory */
      if ((mean = (double *)calloc(data1d.npts, sizeof(double))) == NULL)
	errormsg("epf1dse(): Couldn't allocate memory!");
      if ((rms = (double *)calloc(data1d.npts, sizeof(double))) == NULL)
	errormsg("epf1dse(): Couldn't allocate memory!");
      if ((lrms = (float *)calloc(data1d.npts, sizeof(float))) == NULL)
	errormsg("epf1dse(): Couldn't allocate memory!");
      if ((fmean = (float *)calloc(data1d.npts, sizeof(float))) == NULL)
	errormsg("epf1dse(): Couldn't allocate memory!");
      if ((fx = (float *)calloc(data1d.npts, sizeof(float))) == NULL)
	errormsg("epf1dse(): Couldn't allocate memory!");
      
      /* Smooth the residuals */
      for (i = 0; i < data1d.npts; i++)
	mean[i] = dpercentile(data1d.r + GSL_MAX(0, i - (bs-1)/2),
			      GSL_MIN(data1d.npts, i + (bs+1)/2) - 
			      GSL_MAX(0, i - (bs-1)/2), 0.5);

      /* The model may not be very good, so subtract the smoothed version 
	 from the residuals */
      for (i = 0; i < data1d.npts; i++)
	mean[i] = data1d.r[i] - mean[i];

      /* Calculate the rms */
      for (i = 0; i < data1d.npts; i++) {
	rms[i] = gsl_stats_sd(mean + GSL_MAX(0, i - (bs-1)/2), 1,
			      GSL_MIN(data1d.npts, i + (bs+1)/2) - 
			      GSL_MAX(0, i - (bs-1)/2));
	lrms[i] = (data1d.y[i] <= 0.0) ? 1.0e6 : rms[i] / data1d.y[i] * LOGE;
      }

      /* Copy the log-sigma of undeleted points */
      npts = 0;
      for (i = 0; i < data1d.npts; i++)
	if (!data1d.d[i] && !del[i]) {
	  fmean[npts] = lrms[i];
	  fx[npts] = data1d.fx[i];
	  npts++;
	}

      /* Fit these */
      lin_fit_s(fx, fmean, npts, &efit);
      new = -1;

      /* Plot the result */
      if (env1d.res && !env1d.logp) {
	for (i = 0; i < data1d.npts; i++)
	  fmean[i] = data1d.r[i] - mean[i];
	cpgsci(2);
	cpgline(data1d.npts, data1d.fx, fmean);
	cpgsci(7);
	for (i = 0; i < data1d.npts; i++)
	  fmean[i] += rms[i];
	cpgline(data1d.npts, data1d.fx, fmean);
	for (i = 0; i < data1d.npts; i++)
	  fmean[i] -= 2.0 * rms[i];
	cpgline(data1d.npts, data1d.fx, fmean);
	cpgsci(1);
      } else if (env1d.res && env1d.logp) {
	cpgsci(8);
	cpgline(data1d.npts, data1d.fx, lrms);
	for (i = 0; i < data1d.npts; i++)
	  if (del[i] || data1d.d[i])
	    cpgpt1(data1d.fx[i], lrms[i], 5);
	cpgsci(3);
	cpgdsline(efit);
	cpgsci(1);
      }

      /* Clean up */
      free(mean);
      free(rms);
      free(lrms);
      free(fmean);
      free(fx);

    } else if (com->c[0] == '1' || com->c[0] == '2' || com->c[0] == '3') {
      /* Set the errors */
      if (!new) {
	nferrormsg("You must perform a fit of the rms of the\n\
smoothed residuals first!\n");
	continue;
      }

      imin = sidxnval(data1d.fx, data1d.npts, 0.0);
      if (data1d.y[imin] <= 0.0)
	errormsg("epf1dse(): Negative PSF value at centre!");

      if (com->c[0] == '1') {
	for (i = 0; i < data1d.npts; i++) {
	  data1d.s[i] = efit.c / LOGE * data1d.y[imin];
	  data1d.fs[i] = data1d.s[i];
	  data1d.ls[i] = (data1d.y[i] <= 0.0) ? 1.0e6 : 
	    efit.c * data1d.y[imin] / data1d.y[i];
	}
      } else if (com->c[0] == '2') {
	for (i = 0; i < data1d.npts; i++) {
	  data1d.s[i] = (data1d.y[i] <= 0.0) ? 1.0e6 : 
	    efit.c * sqrt(data1d.y[imin]) / LOGE * sqrt(data1d.y[i]);
	  data1d.fs[i] = data1d.s[i];
	  data1d.ls[i] = (data1d.y[i] <= 0.0) ? 1.0e6 : 
	    efit.c * sqrt(data1d.y[imin]) / sqrt(data1d.y[i]);
	}
      } else if (com->c[0] == '3') {
	for (i = 0; i < data1d.npts; i++) {
	  data1d.s[i] = (data1d.y[i] <= 0.0) ? 1.0e6 : 
	    efit.c / LOGE * data1d.y[i];
	  data1d.fs[i] = data1d.s[i];
	  data1d.ls[i] = efit.c;
	}
      }

      break;
    
    } else if (com->c[0] == 'b') {
      /* Set the boxcar smoothing size */
      if (com->cf) {
	if (sscanf(com->c, "%*s %d", &bs) != 1 || bs < 1 || bs%2 != 1)
	  errormsg("epf1se(): Could not read boxcar smoothing size!");
      } else {
	do
	  cpginput("Boxcar smoothing size?", "%d", &bs);
	while (bs < 1 || bs%2 != 1);
	epf1dplot();
      }

    } else if (com->c[0] == 'k' || com->c[0] == 'u') {
      /* Choose regions to exclude from fit */
      imin = sidxnval(data1d.fx, data1d.npts, com->x);
      fprintf(stderr, "\n... again ...\n");
      cpgsci(7);
      getcom(4, 1, com->x, com->y, com);
      cpgsci(1);
      if (com->c[0] == 'k' || com->c[0] == 'u') {
	imax = sidxnval(data1d.fx, data1d.npts, com->x);
	if (imax < imin) {
	  i = imax;
	  imax = imin;
	  imin = i;
	}
	if (com->c[0] == 'k')
	  for (i = imin; i < imax; i++)
	    del[i] = 1;
	else
	  for (i = imin; i < imax; i++)
	    del[i] = 0;
	epf1dplot();
      }
      
    } else 
      fprintf(stderr, "\nSorry, don't know that command.\n");

  }

  epf1dplot();
  fprintf(stderr, "\nLeaving mode to set fitting weights...\n");
  return;
}
