/*****************************************************************************
* Convert width to HWHM and vice versa, and determine position and height
* of the first maximum
* dir = 0:  w    --> HWHM
* dir = 1:  HWHM --> w
*****************************************************************************/

#include <string.h>
#include <math.h>
#include "const.h"
#include "eltpsffit.h"


/*****************************************************************************
* Position of first maximum of obstructed Airy disk
*****************************************************************************/

double fmp(double q) {

  double    q2;


  q2 = q * q;  
  return 5.1371 * (1.0 - 3.0177e-02 * q + 4.5092e-01 * q2 - 2.3054 * q2*q 
		   + 2.5121 * q2*q2 - 8.8312e-01 * q2*q2*q);
}

/*****************************************************************************
* Relative height of first maximum of obstructed Airy disk
*****************************************************************************/

double h(double q) {

  double   y, res;


  y = fmp(q);
  res = 2.0 * (j1(y) - q * j1(q * y)) / y / (1 - q*q);
  return res * res;
}

/****************************************************************************/


void epf1dw2hwhm(fitc1dim *fitc, int dir) {

  void   errormsg(char *, ...);


  if (dir == 0) {

    if (!strcmp(fitc->type, "g"))
      fitc->hwhm = fitc->w * FWHMSIG / SQRT2 / 2.0;
    else if (!strcmp(fitc->type, "l"))   
      fitc->hwhm = fitc->w;
    else if (!strcmp(fitc->type, "m"))   
      fitc->hwhm = fitc->w * sqrt(pow(2.0, 1.0/fitc->q) - 1.0);
    else if (!strcmp(fitc->type, "s"))
      fitc->hwhm = fitc->w * SHWHM;
    else if (!strcmp(fitc->type, "a"))
      fitc->hwhm = asin(fitc->w * RPMAS * ADHWHM) / RPMAS;
    else if (!strcmp(fitc->type, "o")) {
      fitc->hwhm = asin(fitc->w * RPMAS 
			* (ADHWHM * (1.0 + 0.6 * fitc->q * fitc->q 
				     * (0.5 * fitc->q - 1.0)))) / RPMAS;
    }

  } else if (dir == 1) {

    if (!strcmp(fitc->type, "g"))
      fitc->w = fitc->hwhm / FWHMSIG * SQRT2 * 2.0;
    else if (!strcmp(fitc->type, "l"))   
      fitc->w = fitc->hwhm;
    else if (!strcmp(fitc->type, "m"))   
      fitc->w = fitc->hwhm / sqrt(pow(2.0, 1.0/fitc->q) - 1.0);
    else if (!strcmp(fitc->type, "s"))
      fitc->w = fitc->hwhm / SHWHM;
    else if (!strcmp(fitc->type, "a"))
      fitc->w = sin(fitc->hwhm * RPMAS) / RPMAS / ADHWHM;
    else if (!strcmp(fitc->type, "o")) {
      fitc->w = sin(fitc->hwhm * RPMAS) / RPMAS 
	/ (ADHWHM * (1.0 + 0.6 * fitc->q * fitc->q * (0.5 * fitc->q - 1.0)));
    }

  } else
    errormsg("epf1dw2hwhm(): Bad direction!");

  if (!strcmp(fitc->type, "o")) {
    /* Position and height of first maximum */
    fitc->fmx = asin(fitc->w * RPMAS * fmp(fitc->q)) / RPMAS;
    fitc->fmy = h(fitc->q);
  } else if (!strcmp(fitc->type, "m")) {
    fitc->fmx = fitc->w * sqrt(pow(3.0, 1.0/fitc->q) - 1.0);
    fitc->fmy = 0.3333333;
  }

  return;
}
